/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.DBMSModule;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.web.WebServer;
import org.neo4j.test.rule.SuppressOutput;

public class DBMSModuleTest {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppress((SuppressOutput.Suppressible[])new SuppressOutput.Suppressible[]{SuppressOutput.System.err, SuppressOutput.System.out});

    @Test
    public void shouldRegisterAtRootByDefault() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        Config config = (Config)Mockito.mock(Config.class);
        CommunityNeoServer neoServer = (CommunityNeoServer)Mockito.mock(CommunityNeoServer.class);
        Mockito.when((Object)neoServer.baseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        Mockito.when((Object)((Boolean)config.get(GraphDatabaseSettings.auth_enabled))).thenReturn((Object)true);
        Mockito.when((Object)((List)config.get(ServerSettings.http_paths_blacklist))).thenReturn(Collections.emptyList());
        DBMSModule module = new DBMSModule(webServer, config, () -> new DiscoverableURIs.Builder().build(), (LogProvider)NullLogProvider.getInstance());
        module.start();
        ((WebServer)Mockito.verify((Object)webServer)).addJAXRSClasses(ArgumentMatchers.anyList(), ArgumentMatchers.anyString(), (Collection)ArgumentMatchers.isNull());
    }
}

