/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.http.cypher.integration.TransactionMatchers;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.TestData;
import org.neo4j.test.server.HTTP;
import org.neo4j.test.server.SharedServerTestBase;

public class AbstractRestFunctionalTestBase
extends SharedServerTestBase
implements GraphHolder {
    @Rule
    public TestData<Map<String, Node>> data = TestData.producedThrough((TestData.Producer)GraphDescription.createGraphFor((GraphHolder)this));
    @Rule
    public TestData<RESTRequestGenerator> gen = TestData.producedThrough(RESTRequestGenerator.PRODUCER);

    public GraphDatabaseService graphdb() {
        return AbstractRestFunctionalTestBase.server().getDatabaseService().getDatabase();
    }

    public <T> T resolveDependency(Class<T> cls) {
        return (T)((GraphDatabaseAPI)this.graphdb()).getDependencyResolver().resolveDependency(cls);
    }

    protected static String defaultDatabaseUri() {
        return AbstractRestFunctionalTestBase.databaseUri("neo4j");
    }

    private static String databaseUri(String databaseName) {
        return AbstractRestFunctionalTestBase.databaseUri(AbstractRestFunctionalTestBase.getLocalHttpPort(), databaseName);
    }

    private static String databaseUri(int port, String databaseName) {
        return String.format("http://localhost:%s/db/%s/", port, databaseName);
    }

    protected String dbUri() {
        return "http://localhost:" + AbstractRestFunctionalTestBase.getLocalHttpPort() + "/db/";
    }

    protected static String txUri() {
        return AbstractRestFunctionalTestBase.defaultDatabaseUri() + "tx";
    }

    protected static String txUri(String databaseName) {
        return AbstractRestFunctionalTestBase.databaseUri(databaseName) + "tx";
    }

    protected static String txCommitUri() {
        return AbstractRestFunctionalTestBase.defaultDatabaseUri() + "tx/commit";
    }

    public static String txCommitUri(String databaseName) {
        return AbstractRestFunctionalTestBase.databaseUri(databaseName) + "tx/commit";
    }

    public static String txCommitUri(String databaseName, int port) {
        return AbstractRestFunctionalTestBase.databaseUri(port, databaseName) + "tx/commit";
    }

    protected static String txUri(long txId) {
        return AbstractRestFunctionalTestBase.defaultDatabaseUri() + "tx/" + txId;
    }

    public static long extractTxId(HTTP.Response response) {
        int lastSlash = response.location().lastIndexOf(47);
        String txIdString = response.location().substring(lastSlash + 1);
        return Long.parseLong(txIdString);
    }

    public RESTRequestGenerator gen() {
        return (RESTRequestGenerator)this.gen.get();
    }

    public static int getLocalHttpPort() {
        ConnectorPortRegister connectorPortRegister = (ConnectorPortRegister)AbstractRestFunctionalTestBase.server().getDatabaseService().getSystemDatabase().getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
        return connectorPortRegister.getLocalAddress("http").getPort();
    }

    public static HTTP.Response runQuery(String query, String ... contentTypes) {
        Object resultDataContents = "";
        if (contentTypes.length > 0) {
            resultDataContents = ", 'resultDataContents': [" + Arrays.stream(contentTypes).map(unquoted -> String.format("'%s'", unquoted)).collect(Collectors.joining(",")) + "]";
        }
        return HTTP.POST(AbstractRestFunctionalTestBase.txCommitUri(), HTTP.RawPayload.quotedJson(String.format("{'statements': [{'statement': '%s'%s}]}", query, resultDataContents)));
    }

    public static void assertNoErrors(HTTP.Response response) throws JsonParseException {
        Assert.assertEquals((Object)"[]", (Object)response.get("errors").toString());
        Assert.assertEquals((long)0L, (long)response.get("errors").size());
    }

    public static void assertHasTxLocation(HTTP.Response begin) {
        MatcherAssert.assertThat((Object)begin.location(), TransactionMatchers.matches(AbstractRestFunctionalTestBase.txUri() + "/\\d+"));
    }

    public static void assertHasTxLocation(HTTP.Response begin, String txUri) {
        MatcherAssert.assertThat((Object)begin.location(), TransactionMatchers.matches(String.format("http://localhost:\\d+/%s/\\d+", txUri)));
    }
}

