/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class CommunityServerTestBase
extends ExclusiveServerTestBase {
    protected CommunityNeoServer server;

    @After
    public void cleanup() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    protected void startServer(boolean authEnabled) throws IOException {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), Boolean.toString(authEnabled)).build();
        this.server.start();
    }

    void startServer(boolean authEnabled, String accessControlAllowOrigin) throws IOException {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), Boolean.toString(authEnabled)).withProperty(ServerSettings.http_access_control_allow_origin.name(), accessControlAllowOrigin).build();
        this.server.start();
    }

    String databaseURL() {
        return this.server.baseUri().resolve("db/neo4j/").toString();
    }

    protected String txCommitURL() {
        return this.txCommitURL("neo4j");
    }

    protected String txCommitURL(String database) {
        return this.server.baseUri().resolve(CommunityServerTestBase.txCommitEndpoint(database)).toString();
    }

    protected void assertPermissionErrorAtDataAccess(HTTP.Response response) throws JsonParseException {
        this.assertPermissionError(response, Collections.singletonList(Status.Security.CredentialsExpired.code().serialize()));
    }

    void assertPermissionErrorAtSystemAccess(HTTP.Response response) throws JsonParseException {
        List<String> possibleErrors = Arrays.asList(Status.Security.CredentialsExpired.code().serialize(), Status.Security.Forbidden.code().serialize());
        this.assertPermissionError(response, possibleErrors);
    }

    private void assertPermissionError(HTTP.Response response, List<String> errors) throws JsonParseException {
        Assert.assertThat((Object)response.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.get("errors").size(), (Matcher)CoreMatchers.equalTo((Object)1));
        JsonNode firstError = response.get("errors").get(0);
        Assert.assertThat((Object)firstError.get("code").asText(), (Matcher)Matchers.is((Matcher)Matchers.in(errors)));
        Assert.assertThat((Object)firstError.get("message").asText(), (Matcher)CoreMatchers.startsWith((String)"Permission denied."));
    }

    protected static HTTP.RawPayload query(String statement) {
        return HTTP.RawPayload.rawPayload("{\"statements\":[{\"statement\":\"" + statement + "\"}]}");
    }
}

