/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.bind.ComponentsBinder;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.DatabaseService;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.server.database.LifecycleManagingDatabaseService;
import org.neo4j.server.exception.ServerStartupErrors;
import org.neo4j.server.http.cypher.HttpTransactionManager;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.InputFormatProvider;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.OutputFormatProvider;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;
import org.neo4j.server.web.RotatingRequestLog;
import org.neo4j.server.web.SimpleUriBuilder;
import org.neo4j.server.web.WebServer;
import org.neo4j.ssl.config.SslPolicyLoader;
import org.neo4j.time.Clocks;

public abstract class AbstractNeoServer
implements NeoServer {
    private static final long MINIMUM_TIMEOUT = 1000L;
    private static final long ROUNDING_SECOND = 1000L;
    static final String NEO4J_IS_STARTING_MESSAGE = "======== Neo4j " + Version.getNeo4jVersion() + " ========";
    protected final LogProvider userLogProvider;
    private final Log log;
    private final List<ServerModule> serverModules = new ArrayList<ServerModule>();
    private final SimpleUriBuilder uriBuilder = new SimpleUriBuilder();
    private final List<Pattern> authWhitelist;
    private final Config config;
    private final LifeSupport life = new LifeSupport();
    private final boolean httpEnabled;
    private final boolean httpsEnabled;
    private SocketAddress httpListenAddress;
    private SocketAddress httpsListenAddress;
    private SocketAddress httpAdvertisedAddress;
    private SocketAddress httpsAdvertisedAddress;
    protected final DatabaseService databaseService;
    protected WebServer webServer;
    protected Supplier<AuthManager> authManagerSupplier;
    private Supplier<SslPolicyLoader> sslPolicyFactorySupplier;
    private HttpTransactionManager httpTransactionManager;
    private CompositeDatabaseAvailabilityGuard globalAvailabilityGuard;
    private ConnectorPortRegister connectorPortRegister;
    private RotatingRequestLog requestLog;

    protected abstract Iterable<ServerModule> createServerModules();

    protected abstract WebServer createWebServer();

    public AbstractNeoServer(Config config, GraphFactory graphFactory, ExternalDependencies dependencies) {
        this.config = config;
        this.userLogProvider = dependencies.userLogProvider();
        this.log = this.userLogProvider.getLog(this.getClass());
        this.log.info(NEO4J_IS_STARTING_MESSAGE);
        AbstractNeoServer.verifyConnectorsConfiguration(config);
        this.httpEnabled = (Boolean)config.get(HttpConnector.enabled);
        if (this.httpEnabled) {
            this.httpListenAddress = (SocketAddress)config.get(HttpConnector.listen_address);
            this.httpAdvertisedAddress = (SocketAddress)config.get(HttpConnector.advertised_address);
        }
        this.httpsEnabled = (Boolean)config.get(HttpsConnector.enabled);
        if (this.httpsEnabled) {
            this.httpsListenAddress = (SocketAddress)config.get(HttpsConnector.listen_address);
            this.httpsAdvertisedAddress = (SocketAddress)config.get(HttpsConnector.advertised_address);
        }
        this.authWhitelist = AbstractNeoServer.parseAuthWhitelist(config);
        this.databaseService = new LifecycleManagingDatabaseService(config, graphFactory, dependencies);
        this.life.add((Lifecycle)this.databaseService);
        this.life.add((Lifecycle)new ServerDependenciesLifeCycleAdapter());
        this.life.add((Lifecycle)new ServerComponentsLifecycleAdapter());
    }

    @Override
    public void start() throws ServerStartupException {
        try {
            this.life.start();
        }
        catch (Throwable t) {
            this.life.shutdown();
            throw ServerStartupErrors.translateToServerStartupError(t);
        }
    }

    private HttpTransactionManager createHttpTransactionManager() {
        DependencyResolver dependencyResolver = this.getSystemDatabaseDependencyResolver();
        JobScheduler jobScheduler = (JobScheduler)dependencyResolver.resolveDependency(JobScheduler.class);
        Clock clock = Clocks.systemClock();
        Duration transactionTimeout = this.getTransactionTimeout();
        return new HttpTransactionManager(this.databaseService, jobScheduler, clock, transactionTimeout, this.userLogProvider);
    }

    private Duration getTransactionTimeout() {
        long timeout = ((Duration)this.config.get(ServerSettings.transaction_idle_timeout)).toMillis();
        return Duration.ofMillis(Math.max(timeout, 2000L));
    }

    private void registerModule(ServerModule module) {
        this.serverModules.add(module);
    }

    private void startModules() {
        for (ServerModule module : this.serverModules) {
            module.start();
        }
    }

    private void stopModules() {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (ServerModule module : this.serverModules) {
            try {
                module.stop();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            RuntimeException e = new RuntimeException();
            errors.forEach(e::addSuppressed);
            throw e;
        }
    }

    private void clearModules() {
        this.serverModules.clear();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    protected void configureWebServer() {
        SslPolicyLoader sslPolicyLoader;
        this.webServer.setHttpAddress(this.httpListenAddress);
        this.webServer.setHttpsAddress(this.httpsListenAddress);
        this.webServer.setMaxThreads((Integer)this.config.get(ServerSettings.webserver_max_threads));
        this.webServer.setWadlEnabled((Boolean)this.config.get(ServerSettings.wadl_enabled));
        this.webServer.setComponentsBinder(this.createComponentsBinder());
        if (this.httpsEnabled && (sslPolicyLoader = this.sslPolicyFactorySupplier.get()).hasPolicyForSource(SslPolicyScope.HTTPS)) {
            this.webServer.setSslPolicy(sslPolicyLoader.getPolicy(SslPolicyScope.HTTPS));
        }
    }

    protected void startWebServer() throws Exception {
        try {
            this.setUpHttpLogging();
            this.webServer.start();
            this.registerHttpAddressAfterStartup();
            this.registerHttpsAddressAfterStartup();
            this.log.info("Remote interface available at %s", new Object[]{this.baseUri()});
        }
        catch (Exception e) {
            SocketAddress address = this.httpListenAddress != null ? this.httpListenAddress : this.httpsListenAddress;
            this.log.error("Failed to start Neo4j on %s: %s", new Object[]{address, e.getMessage()});
            throw e;
        }
    }

    private void registerHttpAddressAfterStartup() {
        if (this.httpEnabled) {
            InetSocketAddress localHttpAddress = this.webServer.getLocalHttpAddress();
            this.connectorPortRegister.register("http", localHttpAddress);
            if (this.httpAdvertisedAddress.getPort() == 0) {
                this.httpAdvertisedAddress = new SocketAddress(localHttpAddress.getHostString(), localHttpAddress.getPort());
            }
        }
    }

    private void registerHttpsAddressAfterStartup() {
        if (this.httpsEnabled) {
            InetSocketAddress localHttpsAddress = this.webServer.getLocalHttpsAddress();
            this.connectorPortRegister.register("https", localHttpsAddress);
            if (this.httpsAdvertisedAddress.getPort() == 0) {
                this.httpsAdvertisedAddress = new SocketAddress(localHttpsAddress.getHostString(), localHttpsAddress.getPort());
            }
        }
    }

    private void setUpHttpLogging() throws IOException {
        if (!((Boolean)this.getConfig().get(ServerSettings.http_logging_enabled)).booleanValue()) {
            return;
        }
        DependencyResolver dependencyResolver = this.getSystemDatabaseDependencyResolver();
        this.requestLog = new RotatingRequestLog((FileSystemAbstraction)dependencyResolver.resolveDependency(FileSystemAbstraction.class), (JobScheduler)dependencyResolver.resolveDependency(JobScheduler.class), ((LogTimeZone)this.config.get(GraphDatabaseSettings.db_timezone)).getZoneId(), ((Path)this.config.get(ServerSettings.http_log_path)).toString(), (Long)this.config.get(ServerSettings.http_logging_rotation_size), (Integer)this.config.get(ServerSettings.http_logging_rotation_keep_number));
        this.webServer.setRequestLog(this.requestLog);
    }

    protected DependencyResolver getSystemDatabaseDependencyResolver() {
        return this.databaseService.getSystemDatabase().getDependencyResolver();
    }

    protected List<Pattern> getUriWhitelist() {
        return this.authWhitelist;
    }

    @Override
    public void stop() {
        this.shutdownGlobalAvailabilityGuard();
        this.life.stop();
    }

    private void shutdownGlobalAvailabilityGuard() {
        try {
            if (this.globalAvailabilityGuard != null) {
                this.globalAvailabilityGuard.shutdown();
            }
        }
        catch (Throwable t) {
            this.log.error("Failed to set the global availability guard to shutdown in the process of stopping the Neo4j server", t);
        }
    }

    private void stopWebServer() throws Exception {
        if (this.webServer != null) {
            this.webServer.stop();
        }
        if (this.requestLog != null) {
            this.requestLog.stop();
        }
    }

    @Override
    public DatabaseService getDatabaseService() {
        return this.databaseService;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.httpTransactionManager.getTransactionHandleRegistry();
    }

    @Override
    public URI baseUri() {
        return this.httpAdvertisedAddress != null ? this.uriBuilder.buildURI(this.httpAdvertisedAddress, false) : this.uriBuilder.buildURI(this.httpsAdvertisedAddress, true);
    }

    public Optional<URI> httpsUri() {
        return Optional.ofNullable(this.httpsAdvertisedAddress).map(address -> this.uriBuilder.buildURI((SocketAddress)address, true));
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    private ComponentsBinder createComponentsBinder() {
        DatabaseService database = this.getDatabaseService();
        DatabaseStateService databaseStateService = (DatabaseStateService)this.getSystemDatabaseDependencyResolver().resolveDependency(DatabaseStateService.class);
        ComponentsBinder binder = new ComponentsBinder();
        binder.addSingletonBinding(database, DatabaseService.class);
        binder.addSingletonBinding(databaseStateService, DatabaseStateService.class);
        binder.addSingletonBinding(database.getDatabaseManagementService(), DatabaseManagementService.class);
        binder.addSingletonBinding(this, NeoServer.class);
        binder.addSingletonBinding(this.getConfig(), Config.class);
        binder.addSingletonBinding(this.getWebServer(), WebServer.class);
        binder.addSingletonBinding(new RepresentationFormatRepository(this), RepresentationFormatRepository.class);
        binder.addLazyBinding(InputFormatProvider.class, InputFormat.class);
        binder.addLazyBinding(OutputFormatProvider.class, OutputFormat.class);
        binder.addSingletonBinding(this.httpTransactionManager, HttpTransactionManager.class);
        binder.addLazyBinding(this.authManagerSupplier, AuthManager.class);
        binder.addSingletonBinding(this.userLogProvider, LogProvider.class);
        binder.addSingletonBinding(this.userLogProvider.getLog(NeoServer.class), Log.class);
        return binder;
    }

    private static void verifyConnectorsConfiguration(Config config) {
        boolean httpAndHttpsDisabled;
        boolean bl = httpAndHttpsDisabled = (Boolean)config.get(HttpConnector.enabled) == false && (Boolean)config.get(HttpsConnector.enabled) == false;
        if (httpAndHttpsDisabled) {
            throw new IllegalArgumentException("Either HTTP or HTTPS connector must be configured to run the server");
        }
    }

    private static List<Pattern> parseAuthWhitelist(Config config) {
        return ((List)config.get(ServerSettings.http_auth_whitelist)).stream().map(Pattern::compile).collect(Collectors.toUnmodifiableList());
    }

    private class ServerComponentsLifecycleAdapter
    extends LifecycleAdapter {
        private ServerComponentsLifecycleAdapter() {
        }

        public void start() throws Exception {
            DependencyResolver dependencyResolver = AbstractNeoServer.this.getSystemDatabaseDependencyResolver();
            LogService logService = (LogService)dependencyResolver.resolveDependency(LogService.class);
            Log serverLog = logService.getInternalLog(ServerComponentsLifecycleAdapter.class);
            serverLog.info("Starting web server");
            AbstractNeoServer.this.connectorPortRegister = (ConnectorPortRegister)dependencyResolver.resolveDependency(ConnectorPortRegister.class);
            AbstractNeoServer.this.httpTransactionManager = AbstractNeoServer.this.createHttpTransactionManager();
            AbstractNeoServer.this.globalAvailabilityGuard = (CompositeDatabaseAvailabilityGuard)dependencyResolver.resolveDependency(CompositeDatabaseAvailabilityGuard.class);
            AbstractNeoServer.this.configureWebServer();
            AbstractNeoServer.this.startModules();
            AbstractNeoServer.this.startWebServer();
            serverLog.info("Web server started.");
        }

        public void stop() throws Exception {
            AbstractNeoServer.this.stopWebServer();
            AbstractNeoServer.this.stopModules();
            AbstractNeoServer.this.clearModules();
        }
    }

    private class ServerDependenciesLifeCycleAdapter
    extends LifecycleAdapter {
        private ServerDependenciesLifeCycleAdapter() {
        }

        public void start() {
            DependencyResolver dependencyResolver = AbstractNeoServer.this.getSystemDatabaseDependencyResolver();
            AbstractNeoServer.this.authManagerSupplier = dependencyResolver.provideDependency(AuthManager.class);
            AbstractNeoServer.this.sslPolicyFactorySupplier = dependencyResolver.provideDependency(SslPolicyLoader.class);
            AbstractNeoServer.this.webServer = AbstractNeoServer.this.createWebServer();
            for (ServerModule moduleClass : AbstractNeoServer.this.createServerModules()) {
                AbstractNeoServer.this.registerModule(moduleClass);
            }
        }
    }
}

