/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.Arrays;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.database.CommunityGraphFactory;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.server.modules.AuthorizationModule;
import org.neo4j.server.modules.DBMSModule;
import org.neo4j.server.modules.DatabaseModule;
import org.neo4j.server.modules.LegacyTransactionModule;
import org.neo4j.server.modules.Neo4jBrowserModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.rest.discovery.CommunityDiscoverableURIs;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.server.web.WebServer;

public class CommunityNeoServer
extends AbstractNeoServer {
    public CommunityNeoServer(Config config, ExternalDependencies dependencies) {
        this(config, new CommunityGraphFactory(), dependencies);
    }

    public CommunityNeoServer(Config config, GraphFactory graphFactory, ExternalDependencies dependencies) {
        super(config, graphFactory, dependencies);
    }

    @Override
    protected Iterable<ServerModule> createServerModules() {
        return Arrays.asList(this.createDBMSModule(), new DatabaseModule(this.webServer, this.getConfig()), new LegacyTransactionModule(this.webServer, this.getConfig()), new ThirdPartyJAXRSModule(this.webServer, this.getConfig(), this.userLogProvider), new Neo4jBrowserModule(this.webServer), this.createAuthorizationModule());
    }

    @Override
    protected WebServer createWebServer() {
        NetworkConnectionTracker connectionTracker = (NetworkConnectionTracker)this.getSystemDatabaseDependencyResolver().resolveDependency(NetworkConnectionTracker.class);
        return new Jetty9WebServer(this.userLogProvider, this.getConfig(), connectionTracker);
    }

    protected DBMSModule createDBMSModule() {
        Supplier<DiscoverableURIs> discoverableURIs = () -> CommunityDiscoverableURIs.communityDiscoverableURIs(this.getConfig(), (ConnectorPortRegister)this.getSystemDatabaseDependencyResolver().resolveDependency(ConnectorPortRegister.class));
        return new DBMSModule(this.webServer, this.getConfig(), discoverableURIs, this.userLogProvider);
    }

    protected AuthorizationModule createAuthorizationModule() {
        return new AuthorizationModule(this.webServer, this.authManagerSupplier, this.userLogProvider, this.getConfig(), this.getUriWhitelist());
    }
}

