/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.neo4j.kernel.internal.Version;
import org.neo4j.server.NeoServer;

public class ServerVersionAndEdition {
    private final Map<String, String> serverInfo = new HashMap<String, String>();

    ServerVersionAndEdition(NeoServer neoServer) {
        this(ServerVersionAndEdition.neoDatabaseVersion(), ServerVersionAndEdition.neoServerEdition(neoServer));
    }

    public ServerVersionAndEdition(String version, String edition) {
        this.serverInfo.put("neo4j_version", version);
        this.serverInfo.put("neo4j_edition", edition);
    }

    public void forEach(BiConsumer<String, String> consumer) {
        this.serverInfo.forEach(consumer);
    }

    private static String neoDatabaseVersion() {
        return Version.getKernel().getReleaseVersion();
    }

    private static String neoServerEdition(NeoServer neoServer) {
        String serverClassName = neoServer.getClass().getName().toLowerCase();
        if (serverClassName.contains("enterpriseneoserver")) {
            return "enterprise";
        }
        if (serverClassName.contains("communityneoserver")) {
            return "community";
        }
        throw new IllegalStateException("The Neo Server running is of unknown type. Valid types are Community and Enterprise.");
    }
}

