/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.rest.repr.DefaultFormat;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.StreamingFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.service.Services;

public final class RepresentationFormatRepository {
    private final Map<MediaType, RepresentationFormat> formats;
    private final AbstractNeoServer injectorProvider;

    public RepresentationFormatRepository(AbstractNeoServer injectorProvider) {
        this.injectorProvider = injectorProvider;
        this.formats = new HashMap<MediaType, RepresentationFormat>();
        for (RepresentationFormat format : Services.loadAll(RepresentationFormat.class)) {
            this.formats.put(format.mediaType, format);
        }
    }

    public OutputFormat outputFormat(List<MediaType> acceptable, URI baseUri, MultivaluedMap<String, String> requestHeaders) {
        RepresentationFormat format = this.forHeaders(acceptable, requestHeaders);
        if (format == null) {
            format = this.forMediaTypes(acceptable);
        }
        if (format == null) {
            format = this.useDefault(acceptable);
        }
        return new OutputFormat(format, baseUri);
    }

    private RepresentationFormat forHeaders(List<MediaType> acceptable, MultivaluedMap<String, String> requestHeaders) {
        if (requestHeaders == null) {
            return null;
        }
        if (!this.containsType(acceptable, MediaType.APPLICATION_JSON_TYPE)) {
            return null;
        }
        String streamHeader = (String)requestHeaders.getFirst((Object)"X-Stream");
        if ("true".equalsIgnoreCase(streamHeader)) {
            return this.formats.get(StreamingFormat.MEDIA_TYPE);
        }
        return null;
    }

    private boolean containsType(List<MediaType> mediaTypes, MediaType mediaType) {
        for (MediaType type : mediaTypes) {
            if (!mediaType.getType().equals(type.getType()) || !mediaType.getSubtype().equals(type.getSubtype())) continue;
            return true;
        }
        return false;
    }

    private RepresentationFormat forMediaTypes(List<MediaType> acceptable) {
        for (MediaType type : acceptable) {
            RepresentationFormat format = this.formats.get(type);
            if (format == null) continue;
            return format;
        }
        return null;
    }

    public InputFormat inputFormat(MediaType type) {
        if (type == null) {
            return this.useDefault(new MediaType[0]);
        }
        RepresentationFormat format = this.formats.get(type);
        if (format != null) {
            return format;
        }
        format = this.formats.get(new MediaType(type.getType(), type.getSubtype()));
        if (format != null) {
            return format;
        }
        return this.useDefault(type);
    }

    private DefaultFormat useDefault(List<MediaType> acceptable) {
        return this.useDefault(acceptable.toArray(new MediaType[0]));
    }

    private DefaultFormat useDefault(MediaType ... type) {
        return new DefaultFormat(new JsonFormat(), this.formats.keySet(), type);
    }
}

