/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ConfigUtils;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.server.WebContainerTestUtils;
import org.neo4j.server.configuration.ConfigFileBuilder;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class ConfigLoaderTest {
    @Inject
    private SuppressOutput suppressOutput;
    @Inject
    private TestDirectory testDirectory;

    ConfigLoaderTest() {
    }

    @Test
    void shouldProvideAConfiguration() {
        File configFile = ConfigFileBuilder.builder(this.testDirectory.homeDir()).build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)config);
    }

    @Test
    void shouldUseSpecifiedConfigFile() {
        File configFile = ConfigFileBuilder.builder(this.testDirectory.homeDir()).withNameValue(GraphDatabaseSettings.default_advertised_address.name(), "bar").build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build();
        String EXPECTED_VALUE = "bar";
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar", (Object)((SocketAddress)testConf.get(GraphDatabaseSettings.default_advertised_address)).toString());
    }

    @Test
    void shouldUseSpecifiedHomeDir() {
        File configFile = ConfigFileBuilder.builder(this.testDirectory.homeDir()).build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.testDirectory.homeDir().getAbsolutePath(), (Object)((Path)testConf.get(GraphDatabaseSettings.neo4j_home)).toString());
    }

    @Test
    void shouldUseWorkingDirForHomeDirIfUnspecified() {
        File configFile = ConfigFileBuilder.builder(this.testDirectory.homeDir()).build();
        Config testConf = Config.newBuilder().fromFile(configFile).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)new File(System.getProperty("user.dir")).getAbsolutePath(), (Object)((Path)testConf.get(GraphDatabaseSettings.neo4j_home)).toString());
    }

    @Test
    void shouldAcceptDuplicateKeysWithSameValue() {
        File configFile = ConfigFileBuilder.builder(this.testDirectory.homeDir()).withNameValue(GraphDatabaseSettings.default_advertised_address.name(), "bar").withNameValue(GraphDatabaseSettings.default_advertised_address.name(), "bar").build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)testConf);
        String EXPECTED_VALUE = "bar";
        org.junit.jupiter.api.Assertions.assertEquals((Object)"bar", (Object)((SocketAddress)testConf.get(GraphDatabaseSettings.default_advertised_address)).toString());
    }

    @Test
    void loadOfflineConfigShouldDisableBolt() {
        File configFile = ConfigFileBuilder.builder(this.testDirectory.homeDir()).withNameValue(BoltConnector.enabled.name(), "true").build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build();
        ConfigUtils.disableAllConnectors((Config)testConf);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)testConf);
        org.junit.jupiter.api.Assertions.assertEquals((Object)false, (Object)testConf.get(BoltConnector.enabled));
    }

    @Test
    void loadOfflineConfigAddDisabledBoltConnector() {
        File configFile = ConfigFileBuilder.builder(this.testDirectory.homeDir()).build();
        Config testConf = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build();
        ConfigUtils.disableAllConnectors((Config)testConf);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)testConf);
        org.junit.jupiter.api.Assertions.assertEquals((Object)false, (Object)testConf.get(BoltConnector.enabled));
    }

    @Test
    void shouldFindThirdPartyJaxRsPackages() throws IOException {
        File file = WebContainerTestUtils.createTempConfigFile(this.testDirectory.homeDir());
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file, true));){
            out.write(ServerSettings.third_party_packages.name());
            out.write("=");
            out.write("com.foo.bar=\"mount/point/foo\",");
            out.write("com.foo.baz=\"/bar\",");
            out.write("com.foo.foobarbaz=\"/\"");
            out.write(System.lineSeparator());
        }
        Config config = Config.newBuilder().fromFile(file).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build();
        List thirdpartyJaxRsPackages = (List)config.get(ServerSettings.third_party_packages);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)thirdpartyJaxRsPackages);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)thirdpartyJaxRsPackages.size());
    }

    @Test
    void shouldRetainRegistrationOrderOfThirdPartyJaxRsPackages() {
        File configFile = ConfigFileBuilder.builder(this.testDirectory.homeDir()).withNameValue(ServerSettings.third_party_packages.name(), "org.neo4j.extension.extension1=/extension1,org.neo4j.extension.extension2=/extension2,org.neo4j.extension.extension3=/extension3").build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build();
        List thirdpartyJaxRsPackages = (List)config.get(ServerSettings.third_party_packages);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)thirdpartyJaxRsPackages.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/extension1", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(0)).getMountPoint());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/extension2", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(1)).getMountPoint());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/extension3", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(2)).getMountPoint());
    }

    @Test
    void shouldThrowWhenSpecifiedConfigFileDoesNotExist() {
        File nonExistentConfigFile = new File("/tmp/" + System.currentTimeMillis());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> Config.newBuilder().fromFile(nonExistentConfigFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build());
    }

    @Test
    void shouldWorkFineWhenSpecifiedConfigFileDoesNotExist() {
        File nonExistentConfigFile = new File("/tmp/" + System.currentTimeMillis());
        Config config = Config.newBuilder().fromFileNoThrow(nonExistentConfigFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)config);
    }

    @Test
    void shouldDefaultToCorrectValueForAuthStoreLocation() {
        File configFile = ConfigFileBuilder.builder(this.testDirectory.homeDir()).withoutSetting(GraphDatabaseSettings.data_directory).build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build();
        Assertions.assertThat((Path)((Path)config.get(DatabaseManagementSystemSettings.auth_store_directory))).isEqualTo((Object)new File(this.testDirectory.homeDir(), "data/dbms").getAbsoluteFile().toPath());
    }

    @Test
    void shouldSetAValueForAuthStoreLocation() {
        File configFile = ConfigFileBuilder.builder(this.testDirectory.homeDir()).withSetting(GraphDatabaseSettings.data_directory, "the-data-dir").build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build();
        Assertions.assertThat((Path)((Path)config.get(DatabaseManagementSystemSettings.auth_store_directory))).isEqualTo((Object)new File(this.testDirectory.homeDir(), "the-data-dir/dbms").getAbsoluteFile().toPath());
    }

    @Test
    void shouldNotOverwriteAuthStoreLocationIfProvided() {
        File configFile = ConfigFileBuilder.builder(this.testDirectory.homeDir()).withSetting(GraphDatabaseSettings.data_directory, "the-data-dir").withSetting(GraphDatabaseInternalSettings.auth_store, "foo/bar/auth").build();
        Config config = Config.newBuilder().fromFile(configFile).set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homeDir().toPath()).build();
        Assertions.assertThat((Path)((Path)config.get(GraphDatabaseInternalSettings.auth_store))).isEqualTo((Object)new File(this.testDirectory.homeDir(), "foo/bar/auth").getAbsoluteFile().toPath());
    }
}

