/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.http.cypher.TransactionStateChecker;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.output.json.GraphExtractionWriter;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.mockito.mock.GraphMock;
import org.neo4j.test.mockito.mock.Link;
import org.neo4j.test.mockito.mock.Properties;
import org.neo4j.test.mockito.mock.Property;

class GraphExtractionWriterTest {
    private final Node n1 = GraphMock.node((long)17L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"n1")}), (String[])new String[]{"Foo"});
    private final Node n2 = GraphMock.node((long)666L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"n2")}), (String[])new String[0]);
    private final Node n3 = GraphMock.node((long)42L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"n3")}), (String[])new String[]{"Foo", "Bar"});
    private final Relationship r1 = GraphMock.relationship((long)7L, (Node)this.n1, (String)"ONE", (Node)this.n2, (Property[])new Property[]{Property.property((String)"name", (Object)"r1")});
    private final Relationship r2 = GraphMock.relationship((long)8L, (Node)this.n1, (String)"TWO", (Node)this.n3, (Property[])new Property[]{Property.property((String)"name", (Object)"r2")});
    private final TransactionStateChecker checker = new TransactionStateChecker(id -> false, id -> false);
    private final JsonFactory jsonFactory = new JsonFactory();

    GraphExtractionWriterTest() {
    }

    @Test
    void shouldExtractNodesFromRow() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("n1", this.n1);
        row.put("n2", this.n2);
        row.put("n3", this.n3);
        row.put("other.thing", "hello");
        row.put("some.junk", 39372);
        JsonNode result = this.write(row);
        this.assertNodes(result);
        Assertions.assertEquals((int)0, (int)result.get("graph").get("relationships").size(), (String)"there should be no relationships");
    }

    @Test
    void shouldExtractRelationshipsFromRowAndNodesFromRelationships() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("r1", this.r1);
        row.put("r2", this.r2);
        JsonNode result = this.write(row);
        this.assertNodes(result);
        this.assertRelationships(result);
    }

    @Test
    void shouldExtractPathFromRowAndExtractNodesAndRelationshipsFromPath() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("p", GraphMock.path((Node)this.n2, (Link[])new Link[]{Link.link((Relationship)this.r1, (Node)this.n1), Link.link((Relationship)this.r2, (Node)this.n3)}));
        JsonNode result = this.write(row);
        this.assertNodes(result);
        this.assertRelationships(result);
    }

    @Test
    void shouldExtractGraphFromMapInTheRow() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        HashMap<String, Relationship> map = new HashMap<String, Relationship>();
        row.put("map", map);
        map.put("r1", this.r1);
        map.put("r2", this.r2);
        JsonNode result = this.write(row);
        this.assertNodes(result);
        this.assertRelationships(result);
    }

    @Test
    void shouldExtractGraphFromListInTheRow() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        ArrayList<Relationship> list = new ArrayList<Relationship>();
        row.put("list", list);
        list.add(this.r1);
        list.add(this.r2);
        JsonNode result = this.write(row);
        this.assertNodes(result);
        this.assertRelationships(result);
    }

    @Test
    void shouldExtractGraphFromListInMapInTheRow() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        HashMap map = new HashMap();
        ArrayList<Relationship> list = new ArrayList<Relationship>();
        map.put("list", list);
        row.put("map", map);
        list.add(this.r1);
        list.add(this.r2);
        JsonNode result = this.write(row);
        this.assertNodes(result);
        this.assertRelationships(result);
    }

    @Test
    void shouldExtractGraphFromMapInListInTheRow() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        HashMap<String, Relationship> map = new HashMap<String, Relationship>();
        ArrayList<HashMap<String, Relationship>> list = new ArrayList<HashMap<String, Relationship>>();
        list.add(map);
        row.put("list", list);
        map.put("r1", this.r1);
        map.put("r2", this.r2);
        JsonNode result = this.write(row);
        this.assertNodes(result);
        this.assertRelationships(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode write(Map<String, Object> row) throws IOException, JsonParseException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator json = this.jsonFactory.createGenerator((OutputStream)out);
        json.writeStartObject();
        try {
            RecordEvent recordEvent = new RecordEvent(new ArrayList<String>(row.keySet()), row::get);
            new GraphExtractionWriter().write(json, recordEvent, this.checker);
        }
        finally {
            json.writeEndObject();
            json.flush();
        }
        return JsonHelper.jsonNode((String)out.toString(StandardCharsets.UTF_8.name()));
    }

    private void assertNodes(JsonNode result) {
        JsonNode nodes = result.get("graph").get("nodes");
        Assertions.assertEquals((int)3, (int)nodes.size(), (String)"there should be 3 nodes");
        GraphExtractionWriterTest.assertNode("17", nodes, Arrays.asList("Foo"), Property.property((String)"name", (Object)"n1"));
        GraphExtractionWriterTest.assertNode("666", nodes, Arrays.asList(new String[0]), Property.property((String)"name", (Object)"n2"));
        GraphExtractionWriterTest.assertNode("42", nodes, Arrays.asList("Foo", "Bar"), Property.property((String)"name", (Object)"n3"));
    }

    private void assertRelationships(JsonNode result) {
        JsonNode relationships = result.get("graph").get("relationships");
        Assertions.assertEquals((int)2, (int)relationships.size(), (String)"there should be 2 relationships");
        GraphExtractionWriterTest.assertRelationship("7", relationships, "17", "ONE", "666", Property.property((String)"name", (Object)"r1"));
        GraphExtractionWriterTest.assertRelationship("8", relationships, "17", "TWO", "42", Property.property((String)"name", (Object)"r2"));
    }

    private static void assertNode(String id, JsonNode nodes, List<String> labels, Property ... properties) {
        JsonNode node = GraphExtractionWriterTest.get((Iterable<JsonNode>)nodes, id);
        GraphExtractionWriterTest.assertListEquals("Node[" + id + "].labels", labels, node.get("labels"));
        JsonNode props = node.get("properties");
        Assertions.assertEquals((int)properties.length, (int)props.size(), (String)("length( Node[" + id + "].properties )"));
        for (Property property : properties) {
            GraphExtractionWriterTest.assertJsonEquals("Node[" + id + "].properties[" + property.key() + "]", property.value(), props.get(property.key()));
        }
    }

    private static void assertRelationship(String id, JsonNode relationships, String startNodeId, String type, String endNodeId, Property ... properties) {
        JsonNode relationship = GraphExtractionWriterTest.get((Iterable<JsonNode>)relationships, id);
        Assertions.assertEquals((Object)type, (Object)relationship.get("type").asText(), (String)("Relationship[" + id + "].labels"));
        Assertions.assertEquals((Object)startNodeId, (Object)relationship.get("startNode").asText(), (String)("Relationship[" + id + "].startNode"));
        Assertions.assertEquals((Object)endNodeId, (Object)relationship.get("endNode").asText(), (String)("Relationship[" + id + "].endNode"));
        JsonNode props = relationship.get("properties");
        Assertions.assertEquals((int)properties.length, (int)props.size(), (String)("length( Relationship[" + id + "].properties )"));
        for (Property property : properties) {
            GraphExtractionWriterTest.assertJsonEquals("Relationship[" + id + "].properties[" + property.key() + "]", property.value(), props.get(property.key()));
        }
    }

    private static void assertJsonEquals(String message, Object expected, JsonNode actual) {
        if (expected == null) {
            Assertions.assertTrue((actual == null || actual.isNull() ? 1 : 0) != 0, (String)message);
        } else if (expected instanceof String) {
            Assertions.assertEquals((Object)expected, (Object)actual.asText(), (String)message);
        } else if (expected instanceof Number) {
            Assertions.assertEquals((Object)expected, (Object)actual.asInt(), (String)message);
        } else {
            Assertions.fail((String)(message + " - unexpected type - " + expected));
        }
    }

    private static void assertListEquals(String what, List<String> expected, JsonNode jsonNode) {
        Assertions.assertTrue((boolean)jsonNode.isArray(), (String)(what + " - should be a list"));
        ArrayList<String> actual = new ArrayList<String>(jsonNode.size());
        for (JsonNode node : jsonNode) {
            actual.add(node.asText());
        }
        Assertions.assertEquals(expected, actual, (String)what);
    }

    private static JsonNode get(Iterable<JsonNode> jsonNodes, String id) {
        for (JsonNode jsonNode : jsonNodes) {
            if (!id.equals(jsonNode.get("id").asText())) continue;
            return jsonNode;
        }
        return null;
    }
}

