/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.MapRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;

class MapRepresentationTest {
    MapRepresentationTest() {
    }

    @Test
    void shouldSerializeMapWithSimpleTypes() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"nulls", null, "strings", "a string", "numbers", 42, "booleans", true}));
        OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"));
        String serializedMap = format.assemble((Representation)rep);
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assertions.assertThat(map.get("nulls")).isNull();
        Assertions.assertThat(map.get("strings")).isEqualTo((Object)"a string");
        Assertions.assertThat(map.get("numbers")).isEqualTo((Object)42);
        Assertions.assertThat(map.get("booleans")).isEqualTo((Object)true);
    }

    @Test
    void shouldSerializeMapWithArrayTypes() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"strings", new String[]{"a string", "another string"}, "numbers", new int[]{42, 87}, "booleans", new boolean[]{true, false}, "Booleans", new Boolean[]{Boolean.TRUE, Boolean.FALSE}}));
        OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"));
        String serializedMap = format.assemble((Representation)rep);
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assertions.assertThat(map.get("strings")).isEqualTo(Arrays.asList("a string", "another string"));
        Assertions.assertThat(map.get("numbers")).isEqualTo(Arrays.asList(42, 87));
        Assertions.assertThat(map.get("booleans")).isEqualTo(Arrays.asList(true, false));
        Assertions.assertThat(map.get("Booleans")).isEqualTo(Arrays.asList(true, false));
    }

    @Test
    void shouldSerializeMapWithListsOfSimpleTypes() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"lists of nulls", Arrays.asList(null, null), "lists of strings", Arrays.asList("a string", "another string"), "lists of numbers", Arrays.asList(23, 87, 42), "lists of booleans", Arrays.asList(true, false, true)}));
        OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"));
        String serializedMap = format.assemble((Representation)rep);
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assertions.assertThat(map.get("lists of nulls")).isEqualTo(Arrays.asList(null, null));
        Assertions.assertThat(map.get("lists of strings")).isEqualTo(Arrays.asList("a string", "another string"));
        Assertions.assertThat(map.get("lists of numbers")).isEqualTo(Arrays.asList(23, 87, 42));
        Assertions.assertThat(map.get("lists of booleans")).isEqualTo(Arrays.asList(true, false, true));
    }

    @Test
    void shouldSerializeMapWithMapsOfSimpleTypes() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"maps with nulls", MapUtil.map((Object[])new Object[]{"nulls", null}), "maps with strings", MapUtil.map((Object[])new Object[]{"strings", "a string"}), "maps with numbers", MapUtil.map((Object[])new Object[]{"numbers", 42}), "maps with booleans", MapUtil.map((Object[])new Object[]{"booleans", true})}));
        OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"));
        String serializedMap = format.assemble((Representation)rep);
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assertions.assertThat(((Map)map.get("maps with nulls")).get("nulls")).isNull();
        Assertions.assertThat(((Map)map.get("maps with strings")).get("strings")).isEqualTo((Object)"a string");
        Assertions.assertThat(((Map)map.get("maps with numbers")).get("numbers")).isEqualTo((Object)42);
        Assertions.assertThat(((Map)map.get("maps with booleans")).get("booleans")).isEqualTo((Object)true);
    }

    @Test
    void shouldSerializeArbitrarilyNestedMapsAndLists() throws Exception {
        MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{"a map with a list in it", MapUtil.map((Object[])new Object[]{"a list", Arrays.asList(42, 87)}), "a list with a map in it", Arrays.asList(MapUtil.map((Object[])new Object[]{"foo", "bar", "baz", false}))}));
        OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"));
        String serializedMap = format.assemble((Representation)rep);
        Map map = JsonHelper.jsonToMap((String)serializedMap);
        Assertions.assertThat(((Map)map.get("a map with a list in it")).get("a list")).isEqualTo(List.of(Integer.valueOf(42), Integer.valueOf(87)));
        Assertions.assertThat(((Map)((List)map.get("a list with a map in it")).get(0)).get("foo")).isEqualTo((Object)"bar");
        Assertions.assertThat(((Map)((List)map.get("a list with a map in it")).get(0)).get("baz")).isEqualTo((Object)false);
    }

    @Test
    void shouldSerializeMapsWithNullKeys() throws Exception {
        Object[] values;
        for (Object value : values = new Object[]{null, "string", 42, true, new String[]{"a string", "another string"}, new int[]{42, 87}, new boolean[]{true, false}, Arrays.asList(true, false, true), MapUtil.map((Object[])new Object[]{"numbers", 42, null, "something"}), MapUtil.map((Object[])new Object[]{"a list", Arrays.asList(42, 87), null, Arrays.asList("a", "b")}), Arrays.asList(MapUtil.map((Object[])new Object[]{"foo", "bar", null, false}))}) {
            MapRepresentation rep = new MapRepresentation(MapUtil.map((Object[])new Object[]{null, value}));
            OutputFormat format = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"));
            String serializedMap = format.assemble((Representation)rep);
            Map map = JsonHelper.jsonToMap((String)serializedMap);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)map.size());
            Object actual = map.get("null");
            if (value == null) {
                org.junit.jupiter.api.Assertions.assertNull(actual);
                continue;
            }
            org.junit.jupiter.api.Assertions.assertNotNull(actual);
        }
    }
}

