/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.diagnostics;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSources;
import org.neo4j.server.configuration.ServerSettings;

public class ServerDiagnosticsOfflineReportProvider
extends DiagnosticsOfflineReportProvider {
    private FileSystemAbstraction fs;
    private Config config;

    public ServerDiagnosticsOfflineReportProvider() {
        super("logs", new String[0]);
    }

    public void init(FileSystemAbstraction fs, String defaultDatabaseName, Config config, File storeDirectory) {
        this.fs = fs;
        this.config = config;
    }

    protected List<DiagnosticsReportSource> provideSources(Set<String> classifiers) {
        File httpLog;
        if (classifiers.contains("logs") && this.fs.fileExists(httpLog = ((Path)this.config.get(ServerSettings.http_log_path)).toFile())) {
            return DiagnosticsReportSources.newDiagnosticsRotatingFile((String)"logs/http.log", (FileSystemAbstraction)this.fs, (File)httpLog);
        }
        return Collections.emptyList();
    }
}

