/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.http.cypher.CypherResource;
import org.neo4j.server.http.cypher.format.input.json.JsonMessageBodyReader;
import org.neo4j.server.http.cypher.format.output.json.JsonMessageBodyWriter;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;

public class TransactionModule
implements ServerModule {
    private final Config config;
    private final WebServer webServer;

    public TransactionModule(WebServer webServer, Config config) {
        this.webServer = webServer;
        this.config = config;
    }

    @Override
    public void start() {
        this.webServer.addJAXRSClasses(TransactionModule.jaxRsClasses(), this.mountPoint(), null);
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSClasses(TransactionModule.jaxRsClasses(), this.mountPoint());
    }

    private String mountPoint() {
        return ((URI)this.config.get(ServerSettings.db_api_path)).toString();
    }

    private static List<Class<?>> jaxRsClasses() {
        return List.of(CypherResource.class, JsonMessageBodyReader.class, JsonMessageBodyWriter.class);
    }
}

