/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.ArrayList;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.AbstractNeoWebServer;
import org.neo4j.server.configuration.ConfigurableServerModules;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.AuthorizationModule;
import org.neo4j.server.modules.DBMSModule;
import org.neo4j.server.modules.LegacyTransactionModule;
import org.neo4j.server.modules.Neo4jBrowserModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.modules.TransactionModule;
import org.neo4j.server.rest.discovery.CommunityDiscoverableURIs;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.server.web.WebServer;

public class CommunityNeoWebServer
extends AbstractNeoWebServer {
    public CommunityNeoWebServer(DatabaseManagementService managementService, Dependencies globalDependencies, Config config, LogProvider userLogProvider, DbmsInfo dbmsInfo) {
        super(managementService, globalDependencies, config, userLogProvider, dbmsInfo);
    }

    @Override
    protected Iterable<ServerModule> createServerModules() {
        Config config = this.getConfig();
        Set enabledModules = (Set)config.get(ServerSettings.http_enabled_modules);
        ArrayList<ServerModule> serverModules = new ArrayList<ServerModule>();
        if (!enabledModules.isEmpty()) {
            serverModules.add(this.createDBMSModule());
            if (enabledModules.contains((Object)ConfigurableServerModules.TRANSACTIONAL_ENDPOINTS)) {
                serverModules.add(new TransactionModule(this.webServer, config));
                serverModules.add(new LegacyTransactionModule(this.webServer, config));
            }
            if (enabledModules.contains((Object)ConfigurableServerModules.UNMANAGED_EXTENSIONS)) {
                serverModules.add(new ThirdPartyJAXRSModule(this.webServer, config, this.userLogProvider));
            }
            if (enabledModules.contains((Object)ConfigurableServerModules.BROWSER)) {
                serverModules.add(new Neo4jBrowserModule(this.webServer));
            }
            serverModules.add(this.createAuthorizationModule());
        }
        return serverModules;
    }

    @Override
    protected WebServer createWebServer() {
        Dependencies globalDependencies = this.getGlobalDependencies();
        NetworkConnectionTracker connectionTracker = (NetworkConnectionTracker)globalDependencies.resolveDependency(NetworkConnectionTracker.class);
        Jetty9WebServer webServer = new Jetty9WebServer(this.userLogProvider, this.getConfig(), connectionTracker);
        globalDependencies.satisfyDependency((Object)webServer);
        return webServer;
    }

    protected DBMSModule createDBMSModule() {
        Supplier<DiscoverableURIs> discoverableURIs = () -> CommunityDiscoverableURIs.communityDiscoverableURIs(this.getConfig(), this.connectorPortRegister);
        return new DBMSModule(this.webServer, this.getConfig(), discoverableURIs, this.userLogProvider);
    }

    protected AuthorizationModule createAuthorizationModule() {
        return new AuthorizationModule(this.webServer, this.authManagerSupplier, this.userLogProvider, this.getConfig(), this.getUriWhitelist());
    }
}

