/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.junit.Assert;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public final class WebContainerTestUtils {
    private WebContainerTestUtils() {
    }

    public static Path createTempDir() throws IOException {
        return Files.createTempDirectory("neo4j-test", new FileAttribute[0]);
    }

    public static Path getRelativePath(Path folder, Setting<Path> setting) {
        return folder.resolve((Path)setting.defaultValue());
    }

    public static Map<String, String> getDefaultRelativeProperties(Path folder) {
        HashMap<String, String> settings = new HashMap<String, String>();
        WebContainerTestUtils.addDefaultRelativeProperties(settings, folder);
        return settings;
    }

    public static void addDefaultRelativeProperties(Map<String, String> properties, Path temporaryFolder) {
        WebContainerTestUtils.addRelativeProperty(temporaryFolder, properties, (Setting<Path>)GraphDatabaseSettings.data_directory);
        WebContainerTestUtils.addRelativeProperty(temporaryFolder, properties, (Setting<Path>)GraphDatabaseSettings.logs_directory);
        properties.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
    }

    private static void addRelativeProperty(Path temporaryFolder, Map<String, String> properties, Setting<Path> setting) {
        properties.put(setting.name(), WebContainerTestUtils.getRelativePath(temporaryFolder, setting).toString());
    }

    public static void writeConfigToFile(Map<String, String> properties, Path file) {
        Properties props = WebContainerTestUtils.loadProperties(file);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        WebContainerTestUtils.storeProperties(file, props);
    }

    public static String asOneLine(Map<String, String> properties) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            builder.append(builder.length() > 0 ? "," : "");
            builder.append(property.getKey()).append('=').append(property.getValue());
        }
        return builder.toString();
    }

    private static void storeProperties(Path file, Properties properties) {
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            properties.store(out, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Properties loadProperties(Path file) {
        Properties properties = new Properties();
        if (Files.exists(file, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                properties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }

    public static Path createTempConfigFile(Path parentDir) {
        return parentDir.resolve("test-" + new Random().nextInt() + ".properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withCSVFile(int rowCount, BlockWithCSVFileURL block) throws Exception {
        Path file = Files.createTempFile("file", ".csv", new FileAttribute[0]);
        try {
            try (PrintWriter writer = new PrintWriter(Files.newOutputStream(file, new OpenOption[0]));){
                for (int i = 0; i < rowCount; ++i) {
                    writer.println("1,2,3");
                }
            }
            String url = file.toUri().toURL().toString().replace("\\", "\\\\");
            block.execute(url);
        }
        finally {
            Files.delete(file);
        }
    }

    public static void verifyConnector(GraphDatabaseService db, String name, boolean enabled) {
        HostnamePort address = WebContainerTestUtils.connectorAddress(db, name);
        if (enabled) {
            Assert.assertNotNull((Object)address);
            Assert.assertTrue((boolean)WebContainerTestUtils.canConnectToSocket(address.getHost(), address.getPort()));
        } else {
            Assert.assertNull((Object)address);
        }
    }

    public static HostnamePort connectorAddress(GraphDatabaseService db, String name) {
        ConnectorPortRegister portRegister = (ConnectorPortRegister)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
        return portRegister.getLocalAddress(name);
    }

    private static boolean canConnectToSocket(String host, int port) {
        try {
            new Socket(host, port).close();
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public static interface BlockWithCSVFileURL {
        public void execute(String var1) throws Exception;
    }
}

