/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.http.cypher.InvalidConcurrentTransactionAccess;
import org.neo4j.server.http.cypher.InvalidTransactionId;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionHandleRegistry;
import org.neo4j.server.http.cypher.TransactionLifecycleException;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

class TransactionHandleRegistryTest {
    TransactionHandleRegistryTest() {
    }

    @Test
    void shouldGenerateTransactionId() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Clocks.fakeClock(), Duration.ofMillis(0L), (LogProvider)logProvider);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id1 = registry.begin(handle);
        long id2 = registry.begin(handle);
        org.junit.jupiter.api.Assertions.assertNotEquals((long)id1, (long)id2);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).doesNotHaveAnyLogs();
    }

    @Test
    void shouldStoreSuspendedTransaction() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Clocks.fakeClock(), Duration.ofMillis(0L), (LogProvider)logProvider);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin(handle);
        registry.release(id, handle);
        TransactionHandle acquiredHandle = registry.acquire(id);
        org.junit.jupiter.api.Assertions.assertSame((Object)handle, (Object)acquiredHandle);
        LogAssertions.assertThat((AssertableLogProvider)logProvider).doesNotHaveAnyLogs();
    }

    @Test
    void acquiringATransactionThatHasAlreadyBeenAcquiredShouldThrowInvalidConcurrentTransactionAccess() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Clocks.fakeClock(), Duration.ofMillis(0L), (LogProvider)logProvider);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin(handle);
        registry.release(id, handle);
        registry.acquire(id);
        org.junit.jupiter.api.Assertions.assertThrows(InvalidConcurrentTransactionAccess.class, () -> registry.acquire(id));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).doesNotHaveAnyLogs();
    }

    @Test
    void acquiringANonExistentTransactionShouldThrowErrorInvalidTransactionId() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Clocks.fakeClock(), Duration.ofMillis(0L), (LogProvider)logProvider);
        long madeUpTransactionId = 1337L;
        org.junit.jupiter.api.Assertions.assertThrows(InvalidTransactionId.class, () -> registry.acquire(madeUpTransactionId));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).doesNotHaveAnyLogs();
    }

    @Test
    void transactionsShouldBeEvictedWhenUnusedLongerThanTimeout() throws Exception {
        FakeClock clock = Clocks.fakeClock();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, Duration.ofMillis(0L), (LogProvider)logProvider);
        TransactionHandle oldTx = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        TransactionHandle newTx = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long txId1 = registry.begin(handle);
        long txId2 = registry.begin(handle);
        registry.release(txId1, oldTx);
        clock.forward(1L, TimeUnit.MINUTES);
        registry.release(txId2, newTx);
        registry.rollbackSuspendedTransactionsIdleSince(clock.millis() - 1000L);
        Assertions.assertThat((Object)registry.acquire(txId2)).isEqualTo((Object)newTx);
        org.junit.jupiter.api.Assertions.assertThrows(InvalidTransactionId.class, () -> registry.acquire(txId1));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(TransactionHandleRegistry.class).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{"Transaction with id 1 has been automatically rolled back due to transaction timeout."});
    }

    @Test
    void expiryTimeShouldBeSetToCurrentTimePlusTimeout() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FakeClock clock = Clocks.fakeClock();
        int timeoutLength = 123;
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, Duration.ofMillis(timeoutLength), (LogProvider)logProvider);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin(handle);
        long timesOutAt = registry.release(id, handle);
        Assertions.assertThat((long)timesOutAt).isEqualTo(clock.millis() + (long)timeoutLength);
        clock.forward(1337L, TimeUnit.MILLISECONDS);
        registry.acquire(id);
        timesOutAt = registry.release(id, handle);
        Assertions.assertThat((long)timesOutAt).isEqualTo(clock.millis() + (long)timeoutLength);
    }

    @Test
    void shouldProvideInterruptHandlerForActiveTransaction() throws TransactionLifecycleException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FakeClock clock = Clocks.fakeClock();
        int timeoutLength = 123;
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, Duration.ofMillis(timeoutLength), (LogProvider)logProvider);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin(handle);
        registry.terminate(id);
        ((TransactionHandle)Mockito.verify((Object)handle)).terminate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handle});
    }

    @Test
    void shouldProvideInterruptHandlerForSuspendedTransaction() throws TransactionLifecycleException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FakeClock clock = Clocks.fakeClock();
        int timeoutLength = 123;
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, Duration.ofMillis(timeoutLength), (LogProvider)logProvider);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        long id = registry.begin(handle);
        registry.release(id, handle);
        registry.terminate(id);
        ((TransactionHandle)Mockito.verify((Object)handle)).terminate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handle});
    }

    @Test
    void gettingInterruptHandlerForUnknownIdShouldThrowErrorInvalidTransactionId() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FakeClock clock = Clocks.fakeClock();
        int timeoutLength = 123;
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, Duration.ofMillis(timeoutLength), (LogProvider)logProvider);
        org.junit.jupiter.api.Assertions.assertThrows(InvalidTransactionId.class, () -> registry.terminate(456L));
    }

    @Test
    void sameUserShouldBeAbleToAcquireTransaction() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Clocks.fakeClock(), Duration.ZERO, (LogProvider)logProvider);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        LoginContext loginContext = this.mockLoginContext("Johannes");
        Mockito.when((Object)handle.getLoginContext()).thenReturn((Object)loginContext);
        long id = registry.begin(handle);
        registry.release(id, handle);
        TransactionHandle acquiredHandle = registry.acquire(id, loginContext);
        org.junit.jupiter.api.Assertions.assertSame((Object)handle, (Object)acquiredHandle);
    }

    @Test
    void differentUserShouldNotBeAbleToAcquireTransaction() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Clocks.fakeClock(), Duration.ZERO, (LogProvider)logProvider);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        LoginContext owningUser = this.mockLoginContext("Johannes");
        Mockito.when((Object)handle.getLoginContext()).thenReturn((Object)owningUser);
        long id = registry.begin(handle);
        registry.release(id, handle);
        LoginContext naughtyUser = this.mockLoginContext("Mr. Evil");
        org.junit.jupiter.api.Assertions.assertThrows(InvalidTransactionId.class, () -> registry.acquire(id, naughtyUser));
    }

    @Test
    void shouldRetrieveHandlerLoginContext() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Clocks.fakeClock(), Duration.ZERO, (LogProvider)logProvider);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        LoginContext owningUser = this.mockLoginContext("Johannes");
        Mockito.when((Object)handle.getLoginContext()).thenReturn((Object)owningUser);
        long id = registry.begin(handle);
        LoginContext actualLoginContext = registry.getLoginContextForTransaction(id);
        org.junit.jupiter.api.Assertions.assertSame((Object)owningUser, (Object)actualLoginContext);
    }

    @Test
    void differentUserShouldNotBeAbleToTerminateTransaction() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FakeClock clock = Clocks.fakeClock();
        Duration timeoutLength = Duration.ofMillis(123L);
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, timeoutLength, (LogProvider)logProvider);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        LoginContext loginContext = this.mockLoginContext("Johannes");
        Mockito.when((Object)handle.getLoginContext()).thenReturn((Object)loginContext);
        long id = registry.begin(handle);
        LoginContext otherUser = this.mockLoginContext("Dr. Evil");
        org.junit.jupiter.api.Assertions.assertThrows(InvalidTransactionId.class, () -> registry.terminate(id, otherUser));
    }

    @Test
    void sameUserShouldBeAbleToTerminateTransaction() throws TransactionLifecycleException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FakeClock clock = Clocks.fakeClock();
        Duration timeoutLength = Duration.ofMillis(123L);
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)clock, timeoutLength, (LogProvider)logProvider);
        TransactionHandle handle = (TransactionHandle)Mockito.mock(TransactionHandle.class);
        LoginContext loginContext = this.mockLoginContext("Johannes");
        Mockito.when((Object)handle.getLoginContext()).thenReturn((Object)loginContext);
        long id = registry.begin(handle);
        registry.terminate(id, loginContext);
        ((TransactionHandle)Mockito.verify((Object)handle, (VerificationMode)Mockito.times((int)1))).terminate();
        ((TransactionHandle)Mockito.verify((Object)handle)).getLoginContext();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handle});
    }

    private LoginContext mockLoginContext(String userName) {
        LoginContext loginContext = (LoginContext)Mockito.mock(LoginContext.class);
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)loginContext.subject()).thenReturn((Object)authSubject);
        Mockito.when((Object)authSubject.username()).thenReturn((Object)userName);
        return loginContext;
    }
}

