/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.Assert;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

public class TransactionConditions {
    private TransactionConditions() {
    }

    static Condition<String> validRFCTimestamp() {
        return new Condition(value -> {
            try {
                ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }, "Valid RFC1134 timestamp.", new Object[0]);
    }

    public static Consumer<HTTP.Response> containsNoErrors() {
        return TransactionConditions.hasErrors(new Status[0]);
    }

    public static Consumer<HTTP.Response> hasErrors(Status ... expectedErrors) {
        return response -> {
            try {
                Iterator errors = response.get("errors").iterator();
                Iterator expected = Iterators.iterator((Object[])expectedErrors);
                while (expected.hasNext()) {
                    Assert.assertTrue((boolean)errors.hasNext());
                    Assertions.assertThat((String)((JsonNode)errors.next()).get("code").asText()).isEqualTo(((Status)expected.next()).code().serialize());
                }
                if (errors.hasNext()) {
                    JsonNode error = (JsonNode)errors.next();
                    Assert.fail((String)("Expected no more errors, but got " + error.get("code") + " - '" + error.get("message") + "'."));
                }
            }
            catch (JsonParseException e) {
                Assert.assertNull((Object)((Object)e));
            }
        };
    }

    static JsonNode getJsonNodeWithName(HTTP.Response response, String name) throws JsonParseException {
        return response.get("results").get(0).get("data").get(0).get(name);
    }

    public static Consumer<HTTP.Response> rowContainsDeletedEntities(int nodes, int rels) {
        return response -> {
            try {
                Iterator meta = TransactionConditions.getJsonNodeWithName(response, "meta").iterator();
                int nodeCounter = 0;
                int relCounter = 0;
                block10: for (int i = 0; i < nodes + rels; ++i) {
                    String type;
                    Assert.assertTrue((boolean)meta.hasNext());
                    JsonNode node = (JsonNode)meta.next();
                    Assertions.assertThat((boolean)node.get("deleted").asBoolean()).isEqualTo((Object)Boolean.TRUE);
                    switch (type = node.get("type").asText()) {
                        case "node": {
                            ++nodeCounter;
                            continue block10;
                        }
                        case "relationship": {
                            ++relCounter;
                            continue block10;
                        }
                        default: {
                            Assert.fail((String)("Unexpected type: " + type));
                        }
                    }
                }
                Assert.assertEquals((long)nodes, (long)nodeCounter);
                Assert.assertEquals((long)rels, (long)relCounter);
                while (meta.hasNext()) {
                    JsonNode node = (JsonNode)meta.next();
                    Assertions.assertThat((boolean)node.get("deleted").asBoolean()).isEqualTo((Object)Boolean.FALSE);
                }
            }
            catch (JsonParseException e) {
                Assert.assertNull((Object)((Object)e));
            }
        };
    }

    public static Consumer<HTTP.Response> rowContainsDeletedEntitiesInPath(int nodes, int rels) {
        return response -> {
            try {
                Iterator meta = TransactionConditions.getJsonNodeWithName(response, "meta").iterator();
                int nodeCounter = 0;
                int relCounter = 0;
                Assert.assertTrue((String)"Expected to find a JSON node, but there was none", (boolean)meta.hasNext());
                JsonNode node = (JsonNode)meta.next();
                Assert.assertTrue((String)"Expected the node to be a list (for a path)", (boolean)node.isArray());
                block10: for (JsonNode inner : node) {
                    String type;
                    switch (type = inner.get("type").asText()) {
                        case "node": {
                            if (!inner.get("deleted").asBoolean()) continue block10;
                            ++nodeCounter;
                            continue block10;
                        }
                        case "relationship": {
                            if (!inner.get("deleted").asBoolean()) continue block10;
                            ++relCounter;
                            continue block10;
                        }
                    }
                    Assert.fail((String)("Unexpected type: " + type));
                }
                Assert.assertEquals((long)nodes, (long)nodeCounter);
                Assert.assertEquals((long)rels, (long)relCounter);
            }
            catch (JsonParseException e) {
                Assert.assertNull((Object)((Object)e));
            }
        };
    }

    public static Consumer<HTTP.Response> rowContainsMetaNodesAtIndex(int ... indexes) {
        return response -> TransactionConditions.assertElementAtMetaIndex(response, indexes, "node");
    }

    public static Consumer<HTTP.Response> rowContainsMetaRelsAtIndex(int ... indexes) {
        return response -> TransactionConditions.assertElementAtMetaIndex(response, indexes, "relationship");
    }

    private static void assertElementAtMetaIndex(HTTP.Response response, int[] indexes, String element) {
        try {
            Iterator meta = TransactionConditions.getJsonNodeWithName(response, "meta").iterator();
            int i = 0;
            int metaIndex = 0;
            while (meta.hasNext() && i < indexes.length) {
                JsonNode node = (JsonNode)meta.next();
                if (!node.isNull()) {
                    String type = node.get("type").asText();
                    if (type.equals(element)) {
                        Assert.assertEquals((String)("Expected " + element + " to be at indexes " + Arrays.toString(indexes) + ", but found it at " + metaIndex), (long)indexes[i], (long)metaIndex);
                        ++i;
                    } else {
                        Assert.assertNotEquals((String)("Expected " + element + " at index " + metaIndex + ", but found " + type), (long)indexes[i], (long)metaIndex);
                    }
                }
                ++metaIndex;
            }
            Assert.assertEquals((long)indexes.length, (long)i);
        }
        catch (JsonParseException e) {
            Assert.assertNull((Object)((Object)e));
        }
    }

    public static Consumer<HTTP.Response> rowContainsAMetaListAtIndex(int index) {
        return response -> {
            try {
                Iterator meta = TransactionConditions.getJsonNodeWithName(response, "meta").iterator();
                int metaIndex = 0;
                while (meta.hasNext()) {
                    JsonNode node = (JsonNode)meta.next();
                    if (metaIndex == index) {
                        Assert.assertTrue((boolean)node.isArray());
                    }
                    ++metaIndex;
                }
            }
            catch (JsonParseException e) {
                Assert.assertNull((Object)((Object)e));
            }
        };
    }

    public static Consumer<HTTP.Response> restContainsDeletedEntities(int amount) {
        return response -> {
            try {
                Iterator entities = TransactionConditions.getJsonNodeWithName(response, "rest").iterator();
                for (int i = 0; i < amount; ++i) {
                    Assert.assertTrue((boolean)entities.hasNext());
                    JsonNode node = (JsonNode)entities.next();
                    Assertions.assertThat((boolean)node.get("metadata").get("deleted").asBoolean()).isEqualTo((Object)Boolean.TRUE);
                }
                if (entities.hasNext()) {
                    Assert.fail((String)"Expected no more entities");
                }
            }
            catch (JsonParseException e) {
                Assert.assertNull((Object)((Object)e));
            }
        };
    }

    public static Consumer<HTTP.Response> graphContainsDeletedNodes(int amount) {
        return response -> {
            try {
                Iterator nodes = TransactionConditions.getJsonNodeWithName(response, "graph").get("nodes").iterator();
                int deleted = 0;
                while (nodes.hasNext()) {
                    JsonNode node = (JsonNode)nodes.next();
                    if (node.get("deleted") == null) continue;
                    Assert.assertTrue((boolean)node.get("deleted").asBoolean());
                    ++deleted;
                }
                Assert.assertEquals((String)String.format("Expected to see %d deleted elements but %d was encountered.", amount, deleted), (long)amount, (long)deleted);
            }
            catch (JsonParseException e) {
                Assert.assertNull((Object)((Object)e));
            }
        };
    }

    public static Consumer<HTTP.Response> graphContainsNoDeletedEntities() {
        return response -> {
            try {
                for (JsonNode node : TransactionConditions.getJsonNodeWithName(response, "graph").get("nodes")) {
                    Assert.assertNull((Object)node.get("deleted"));
                }
                for (JsonNode node : TransactionConditions.getJsonNodeWithName(response, "graph").get("relationships")) {
                    Assert.assertNull((Object)node.get("deleted"));
                }
            }
            catch (JsonParseException e) {
                Assert.assertNull((Object)((Object)e));
            }
        };
    }

    public static Consumer<HTTP.Response> rowContainsNoDeletedEntities() {
        return response -> {
            try {
                for (JsonNode node : TransactionConditions.getJsonNodeWithName(response, "meta")) {
                    Assert.assertFalse((boolean)node.get("deleted").asBoolean());
                }
            }
            catch (JsonParseException e) {
                Assert.assertNull((Object)((Object)e));
            }
        };
    }

    public static Consumer<HTTP.Response> restContainsNoDeletedEntities() {
        return response -> {
            try {
                for (JsonNode node : TransactionConditions.getJsonNodeWithName(response, "rest")) {
                    Assert.assertNull((Object)node.get("metadata").get("deleted"));
                }
            }
            catch (JsonParseException e) {
                Assert.assertNull((Object)((Object)e));
            }
        };
    }

    public static Consumer<HTTP.Response> graphContainsDeletedRelationships(int amount) {
        return response -> {
            try {
                Iterator relationships = TransactionConditions.getJsonNodeWithName(response, "graph").get("relationships").iterator();
                for (int i = 0; i < amount; ++i) {
                    Assert.assertTrue((boolean)relationships.hasNext());
                    JsonNode node = (JsonNode)relationships.next();
                    Assertions.assertThat((boolean)node.get("deleted").asBoolean()).isEqualTo((Object)Boolean.TRUE);
                }
                if (relationships.hasNext()) {
                    JsonNode node = (JsonNode)relationships.next();
                    Assert.fail((String)("Expected no more nodes, but got a node with id " + node.get("id")));
                }
            }
            catch (JsonParseException e) {
                Assert.assertNull((Object)((Object)e));
            }
        };
    }

    public static long countNodes(GraphDatabaseService graphdb) {
        try (Transaction transaction = graphdb.beginTx();){
            long count = 0L;
            ResourceIterator allNodes = transaction.getAllNodes().iterator();
            while (allNodes.hasNext()) {
                allNodes.next();
                ++count;
            }
            long l = count;
            return l;
        }
    }

    public static Condition<? super HTTP.Response> containsNoStackTraces() {
        return new Condition(response -> {
            Map content = (Map)response.content();
            List errors = (List)content.get("errors");
            for (Map error : errors) {
                if (!error.containsKey("stackTrace")) continue;
                return false;
            }
            return true;
        }, "Contains stack traces.", new Object[0]);
    }
}

