/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class ServerSettingsMigratorTest {
    @Inject
    private TestDirectory testDirectory;

    ServerSettingsMigratorTest() {
    }

    @Test
    void testWhitelistSettingsRename() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.security.http_auth_whitelist=a,b"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessageWithArguments("Use of deprecated setting %s. It is replaced by %s", new Object[]{"dbms.security.http_auth_whitelist", ServerSettings.http_auth_allowlist.name()});
        Assertions.assertEquals(List.of("a", "b"), (Object)config.get(ServerSettings.http_auth_allowlist));
    }
}

