/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoWebServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.web.WebServer;

class ThirdPartyJAXRSModuleTest {
    ThirdPartyJAXRSModuleTest() {
    }

    @Test
    void shouldReportThirdPartyPackagesAtSpecifiedMount() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        CommunityNeoWebServer neoServer = (CommunityNeoWebServer)Mockito.mock(CommunityNeoWebServer.class);
        Mockito.when((Object)neoServer.getBaseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        Config config = (Config)Mockito.mock(Config.class);
        ArrayList<ThirdPartyJaxRsPackage> jaxRsPackages = new ArrayList<ThirdPartyJaxRsPackage>();
        String path = "/third/party/package";
        jaxRsPackages.add(new ThirdPartyJaxRsPackage("org.example.neo4j", path));
        Mockito.when((Object)((List)config.get(ServerSettings.third_party_packages))).thenReturn(jaxRsPackages);
        ThirdPartyJAXRSModule module = new ThirdPartyJAXRSModule(webServer, config, (LogProvider)NullLogProvider.getInstance());
        module.start();
        ((WebServer)Mockito.verify((Object)webServer)).addJAXRSPackages((List)ArgumentMatchers.any(List.class), ArgumentMatchers.anyString(), (Collection)ArgumentMatchers.any());
    }
}

