/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.server.rest.repr.DefaultFormat;
import org.neo4j.server.rest.repr.MediaTypeNotSupportedException;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;

public class DefaultFormatTest {
    private DefaultFormat input;

    @BeforeEach
    public void setUp() {
        JsonFormat inner = new JsonFormat();
        ArrayList supported = new ArrayList();
        MediaType requested = MediaType.APPLICATION_JSON_TYPE;
        this.input = new DefaultFormat((RepresentationFormat)inner, supported, new MediaType[]{requested});
    }

    @Test
    public void canReadEmptyMap() throws Exception {
        Map map = this.input.readMap("{}", new String[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)map);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)map.isEmpty(), (String)"map is not empty");
    }

    @Test
    public void canReadMapWithTwoValues() throws Exception {
        Map map = this.input.readMap("{\"key1\":\"value1\",     \"key2\":\"value11\"}", new String[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)map);
        Assertions.assertThat((Map)map).containsEntry((Object)"key1", (Object)"value1");
        Assertions.assertThat((Map)map).containsEntry((Object)"key2", (Object)"value11");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)map.size(), (String)"map contained extra values");
    }

    @Test
    public void canReadMapWithNestedMap() throws Exception {
        Map map = this.input.readMap("{\"nested\": {\"key\": \"valuable\"}}", new String[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)map);
        Assertions.assertThat((Map)map).containsKey((Object)"nested");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)map.size(), (String)"map contained extra values");
        Object nested = map.get("nested");
        Assertions.assertThat(nested).isInstanceOf(Map.class);
        Map nestedMap = (Map)nested;
        Assertions.assertThat((Map)nestedMap).containsEntry((Object)"key", (Object)"valuable");
    }

    @Test
    public void failsWithTheCorrectExceptionWhenGettingTheWrongInput() {
        org.junit.jupiter.api.Assertions.assertThrows(MediaTypeNotSupportedException.class, () -> this.input.readValue("<xml />"));
    }

    @Test
    public void failsWithTheCorrectExceptionWhenGettingTheWrongInput2() {
        org.junit.jupiter.api.Assertions.assertThrows(MediaTypeNotSupportedException.class, () -> this.input.readMap("<xml />", new String[0]));
    }

    @Test
    public void failsWithTheCorrectExceptionWhenGettingTheWrongInput3() {
        org.junit.jupiter.api.Assertions.assertThrows(MediaTypeNotSupportedException.class, () -> this.input.readUri("<xml />"));
    }
}

