/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.memory.MemoryPool;
import org.neo4j.server.http.cypher.Invocation;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.RollbackInvocation;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.http.cypher.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.http.cypher.format.api.ConnectionException;
import org.neo4j.server.http.cypher.format.api.InputEventStream;
import org.neo4j.server.http.cypher.format.api.InputFormatException;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class InvocationTest {
    private static final MapValue NO_PARAMS = VirtualValues.EMPTY_MAP;
    private static final Statement NULL_STATEMENT = null;
    private final Log log = (Log)Mockito.mock(Log.class);
    private final Result executionResult = (Result)Mockito.mock(Result.class);
    private final QueryExecutionType queryExecutionType = null;
    private final org.neo4j.cypher.internal.runtime.QueryStatistics queryStatistics = (org.neo4j.cypher.internal.runtime.QueryStatistics)Mockito.mock(org.neo4j.cypher.internal.runtime.QueryStatistics.class);
    private final ExecutionPlanDescription executionPlanDescription = (ExecutionPlanDescription)Mockito.mock(ExecutionPlanDescription.class);
    private final Iterable<Notification> notifications = Collections.emptyList();
    private final List<Result.ResultRow> resultRows = new ArrayList<Result.ResultRow>();
    private final TransitionalTxManagementKernelTransaction transactionContext = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
    private final GraphDatabaseFacade databaseFacade = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
    private final QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
    private final InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
    private final TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
    private final OutputEventStream outputEventStream = (OutputEventStream)Mockito.mock(OutputEventStream.class);
    private static final TransactionUriScheme uriScheme = new TransactionUriScheme(){

        public URI txUri(long id) {
            return URI.create("transaction/" + id);
        }

        public URI txCommitUri(long id) {
            return URI.create("transaction/" + id + "/commit");
        }

        public URI dbUri() {
            return URI.create("data/");
        }
    };

    InvocationTest() {
    }

    @BeforeEach
    void setUp() {
        ((Result)Mockito.doAnswer(invocation -> {
            Result.ResultVisitor resultVisitor = (Result.ResultVisitor)invocation.getArgument(0);
            for (Result.ResultRow resultRow : this.resultRows) {
                resultVisitor.visit(resultRow);
            }
            return null;
        }).when((Object)this.executionResult)).accept((Result.ResultVisitor)Mockito.any());
        Mockito.when((Object)this.databaseFacade.beginTransaction((KernelTransaction.Type)Mockito.any(), (LoginContext)Mockito.any(), (ClientConnectionInfo)Mockito.any())).thenReturn((Object)this.internalTransaction);
        Mockito.when((Object)this.executionResult.getQueryExecutionType()).thenReturn((Object)this.queryExecutionType);
        Mockito.when((Object)this.executionResult.getQueryStatistics()).thenReturn((Object)this.queryStatistics);
        Mockito.when((Object)this.executionResult.getExecutionPlanDescription()).thenReturn((Object)this.executionPlanDescription);
        Mockito.when((Object)this.executionResult.getNotifications()).thenReturn(this.notifications);
    }

    @Test
    void shouldExecuteStatements() {
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).execute("query", Collections.emptyMap());
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldSuspendTransactionAndReleaseForOtherRequestsAfterExecutingStatements() {
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, false);
        invocation.execute(this.outputEventStream);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.transactionContext, this.registry});
        ((TransactionRegistry)transactionOrder.verify((Object)this.registry)).release(1337L, handle);
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).execute("query", Collections.emptyMap());
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.OPEN, uriScheme.txCommitUri(1337L), 0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldResumeTransactionWhenExecutingStatementsOnSecondRequest() {
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, false);
        invocation.execute(this.outputEventStream);
        Mockito.reset((Object[])new Object[]{this.transactionContext, this.registry, this.internalTransaction, this.outputEventStream});
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenReturn((Object)this.executionResult);
        invocation.execute(this.outputEventStream);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.transactionContext, this.registry, this.internalTransaction});
        ((InternalTransaction)order.verify((Object)this.internalTransaction)).execute("query", Collections.emptyMap());
        ((TransactionRegistry)order.verify((Object)this.registry)).release(1337L, handle);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.OPEN, uriScheme.txCommitUri(1337L), 0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldCommitSinglePeriodicCommitStatement() {
        String queryText = "USING PERIODIC COMMIT CREATE()";
        InternalTransaction transaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Mockito.when((Object)this.databaseFacade.beginTransaction((KernelTransaction.Type)Mockito.eq((Object)KernelTransaction.Type.IMPLICIT), (LoginContext)Mockito.any(LoginContext.class), (ClientConnectionInfo)Mockito.any(ClientConnectionInfo.class), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.execute((String)Mockito.eq((Object)queryText), (Map)Mockito.any())).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.executionEngine.isPeriodicCommit(queryText)).thenReturn((Object)true);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement(queryText, MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldCommitTransactionAndTellRegistryToForgetItsHandle() {
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.internalTransaction, this.registry});
        ((InternalTransaction)transactionOrder.verify((Object)this.internalTransaction)).commit();
        ((TransactionRegistry)transactionOrder.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldRollbackTransactionAndTellRegistryToForgetItsHandle() {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        RollbackInvocation invocation = new RollbackInvocation(this.log, handle);
        invocation.execute(this.outputEventStream);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.internalTransaction, this.registry});
        ((InternalTransaction)transactionOrder.verify((Object)this.internalTransaction)).rollback();
        ((TransactionRegistry)transactionOrder.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, null, -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldCreateTransactionContextOnlyWhenFirstNeeded() {
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.databaseFacade});
        invocation.execute(this.outputEventStream);
        ((GraphDatabaseFacade)Mockito.verify((Object)this.databaseFacade)).beginTransaction((KernelTransaction.Type)Mockito.any(KernelTransaction.Type.class), (LoginContext)Mockito.any(LoginContext.class), (ClientConnectionInfo)Mockito.eq((Object)ClientConnectionInfo.EMBEDDED_CONNECTION));
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldRollbackTransactionIfExecutionErrorOccurs() {
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenThrow(new Throwable[]{new IllegalStateException("Something went wrong")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).execute("query", Collections.emptyMap());
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.ExecutionFailed, "Something went wrong");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleCommitError() {
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenReturn((Object)this.executionResult);
        ((InternalTransaction)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Something went wrong")}).when((Object)this.internalTransaction)).commit();
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).execute("query", Collections.emptyMap());
        ((Log)Mockito.verify((Object)this.log)).error((String)Mockito.eq((Object)"Failed to commit transaction."), (Throwable)Mockito.any(IllegalStateException.class));
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Transaction.TransactionCommitFailed, "Something went wrong");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.UNKNOWN, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleErrorWhenStartingTransaction() {
        Mockito.when((Object)this.databaseFacade.beginTransaction((KernelTransaction.Type)Mockito.any(), (LoginContext)Mockito.any(), (ClientConnectionInfo)Mockito.any())).thenThrow(new Throwable[]{new IllegalStateException("Something went wrong")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((Log)Mockito.verify((Object)this.log)).error((String)Mockito.eq((Object)"Failed to start transaction"), (Throwable)Mockito.any(IllegalStateException.class));
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Transaction.TransactionStartFailed, "Something went wrong");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.NO_TRANSACTION, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleAuthorizationErrorWhenStartingTransaction() {
        Mockito.when((Object)this.databaseFacade.beginTransaction((KernelTransaction.Type)Mockito.any(), (LoginContext)Mockito.any(), (ClientConnectionInfo)Mockito.any())).thenThrow(new Throwable[]{new AuthorizationViolationException("Forbidden")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.log});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Security.Forbidden, "Forbidden");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.NO_TRANSACTION, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleCypherSyntaxError() {
        String queryText = "matsch (n) return n";
        Mockito.when((Object)this.internalTransaction.execute(queryText, Collections.emptyMap())).thenThrow(new Throwable[]{new RuntimeException((Throwable)new SyntaxException("did you mean MATCH?"))});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement(queryText, MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.SyntaxError, "did you mean MATCH?");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleExecutionEngineThrowingUndeclaredCheckedExceptions() {
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenThrow(new Throwable[]{new RuntimeException("BOO")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.ExecutionFailed, "BOO");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleRollbackError() {
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenThrow(new Throwable[]{new RuntimeException("BOO")});
        ((InternalTransaction)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Something went wrong")}).when((Object)this.internalTransaction)).rollback();
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).execute("query", Collections.emptyMap());
        ((Log)Mockito.verify((Object)this.log)).error((String)Mockito.eq((Object)"Failed to roll back transaction."), (Throwable)Mockito.any(IllegalStateException.class));
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.ExecutionFailed, "BOO");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Transaction.TransactionRollbackFailed, "Something went wrong");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.UNKNOWN, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldInterruptTransaction() throws Exception {
        TransactionalContext transactionalContext = InvocationTest.prepareKernelWithQuerySession();
        Mockito.when((Object)this.executionEngine.executeQuery("query", NO_PARAMS, transactionalContext, false)).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        handle.terminate();
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).terminate();
    }

    @Test
    void deadlockExceptionHasCorrectStatus() {
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenThrow(new Throwable[]{new DeadlockDetectedException("deadlock")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Transaction.DeadlockDetected, "deadlock");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void startTransactionWithRequestedTimeout() {
        TransactionHandle handle = new TransactionHandle((GraphDatabaseAPI)this.databaseFacade, this.executionEngine, (TransactionRegistry)Mockito.mock(TransactionRegistry.class), uriScheme, true, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, 100L);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenReturn(null);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((GraphDatabaseFacade)Mockito.verify((Object)this.databaseFacade)).beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, 100L, TimeUnit.MILLISECONDS);
    }

    @Test
    void shouldHandleInputParsingErrorWhenReadingStatements() {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenThrow(new Throwable[]{new InputFormatException("Cannot parse input", (Throwable)new IOException("JSON ERROR"))});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Request.InvalidFormat, "Cannot parse input");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleConnectionErrorWhenReadingStatementsInImplicitTransaction() {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenThrow(new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        ConnectionException e = (ConnectionException)Assertions.assertThrows(ConnectionException.class, () -> invocation.execute(this.outputEventStream));
        Assertions.assertEquals((Object)"Connection error", (Object)e.getMessage());
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldKeepTransactionOpenIfConnectionErrorWhenReadingStatementsInExplicitTransaction() {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry, false);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenThrow(new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        ConnectionException e = (ConnectionException)Assertions.assertThrows(ConnectionException.class, () -> invocation.execute(this.outputEventStream));
        Assertions.assertEquals((Object)"Connection error", (Object)e.getMessage());
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext, (VerificationMode)Mockito.never())).rollback();
        ((TransitionalTxManagementKernelTransaction)Mockito.verify((Object)this.transactionContext, (VerificationMode)Mockito.never())).commit();
        ((TransactionRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.never())).forget(1337L);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleConnectionErrorWhenWritingOutputInImplicitTransaction() {
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        ((OutputEventStream)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))}).when((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ConnectionException e = (ConnectionException)Assertions.assertThrows(ConnectionException.class, () -> invocation.execute(this.outputEventStream));
        Assertions.assertEquals((Object)"Connection error", (Object)e.getMessage());
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction)).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldKeepTransactionOpenIfConnectionErrorWhenWritingOutputInImplicitTransaction() {
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry, false);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, false);
        ((OutputEventStream)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))}).when((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ConnectionException e = (ConnectionException)Assertions.assertThrows(ConnectionException.class, () -> invocation.execute(this.outputEventStream));
        Assertions.assertEquals((Object)"Connection error", (Object)e.getMessage());
        ((InternalTransaction)Mockito.verify((Object)this.internalTransaction, (VerificationMode)Mockito.never())).rollback();
        ((TransactionRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.never())).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd(this.queryExecutionType, (QueryStatistics)this.queryStatistics, this.executionPlanDescription, this.notifications);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldAllocateAndFreeMemory() {
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry, false);
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)new Statement("query", MapUtil.map((Object[])new Object[0])), (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        Invocation invocation = new Invocation((Log)Mockito.mock(Log.class), handle, uriScheme.txCommitUri(1337L), memoryPool, inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((MemoryPool)Mockito.verify((Object)memoryPool, (VerificationMode)Mockito.times((int)2))).reserveHeap(Statement.SHALLOW_SIZE);
        ((MemoryPool)Mockito.verify((Object)memoryPool, (VerificationMode)Mockito.times((int)2))).releaseHeap(Statement.SHALLOW_SIZE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{memoryPool});
    }

    @Test
    void shouldFreeMemoryOnException() {
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry, false);
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)this.internalTransaction.execute("query", Collections.emptyMap())).thenReturn((Object)this.executionResult);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)new Statement("query", MapUtil.map((Object[])new Object[0])), (Object[])new Statement[]{NULL_STATEMENT});
        this.mockDefaultResult();
        ((OutputEventStream)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectionException("Something broke", (Throwable)new IOException("Oh no"))}).when((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        Invocation invocation = new Invocation((Log)Mockito.mock(Log.class), handle, uriScheme.txCommitUri(1337L), memoryPool, inputEventStream, true);
        Assertions.assertThrows(ConnectionException.class, () -> invocation.execute(this.outputEventStream));
        ((MemoryPool)Mockito.verify((Object)memoryPool)).reserveHeap(Statement.SHALLOW_SIZE);
        ((MemoryPool)Mockito.verify((Object)memoryPool)).releaseHeap(Statement.SHALLOW_SIZE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{memoryPool});
    }

    private void mockDefaultResult() {
        Mockito.when((Object)this.executionResult.columns()).thenReturn(List.of("c1", "c2", "c3"));
        this.mockResultRow(Map.of("c1", "v1", "c2", "v2", "c3", "v3"));
        this.mockResultRow(Map.of("c1", "v4", "c2", "v5", "c3", "v6"));
    }

    private void verifyDefaultResultRows(InOrder outputOrder) {
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeRecord((List)Mockito.eq(List.of("c1", "c2", "c3")), (Function)ArgumentMatchers.argThat((ArgumentMatcher)new ValuesMatcher(Map.of("c1", "v1", "c2", "v2", "c3", "v3"))));
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeRecord((List)Mockito.eq(List.of("c1", "c2", "c3")), (Function)ArgumentMatchers.argThat((ArgumentMatcher)new ValuesMatcher(Map.of("c1", "v4", "c2", "v5", "c3", "v6"))));
    }

    private TransactionHandle getTransactionHandle(QueryExecutionEngine executionEngine, TransactionRegistry registry) {
        return this.getTransactionHandle(executionEngine, registry, true);
    }

    private TransactionHandle getTransactionHandle(QueryExecutionEngine executionEngine, TransactionRegistry registry, boolean implicitTransaction) {
        return new TransactionHandle((GraphDatabaseAPI)this.databaseFacade, executionEngine, registry, uriScheme, implicitTransaction, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, Mockito.anyLong());
    }

    private static TransactionalContext prepareKernelWithQuerySession() {
        return (TransactionalContext)Mockito.mock(TransactionalContext.class);
    }

    private void mockResultRow(Map<String, Object> row) {
        Result.ResultRow resultRow = (Result.ResultRow)Mockito.mock(Result.ResultRow.class);
        row.forEach((key, value) -> Mockito.when((Object)resultRow.get(key)).thenReturn(value));
        this.resultRows.add(resultRow);
    }

    private static class ValuesMatcher
    implements ArgumentMatcher<Function<String, Object>> {
        private final Map<String, Object> values;

        private ValuesMatcher(Map<String, Object> values) {
            this.values = values;
        }

        public boolean matches(Function<String, Object> valueExtractor) {
            return this.values.entrySet().stream().anyMatch(entry -> entry.getValue().equals(valueExtractor.apply((String)entry.getKey())));
        }
    }
}

