/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.repr.RepresentationTestBase;
import org.neo4j.test.mockito.mock.GraphMock;
import org.neo4j.test.mockito.mock.Properties;
import org.neo4j.test.mockito.mock.Property;

class RelationshipRepresentationTest {
    RelationshipRepresentationTest() {
    }

    @Test
    void shouldHaveSelfLink() {
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+", RelationshipRepresentationTest.relrep(1234L).selfUri());
    }

    @Test
    void shouldHaveType() {
        Assertions.assertNotNull((Object)RelationshipRepresentationTest.relrep(1234L).getType());
    }

    @Test
    void shouldHaveStartNodeLink() {
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", RelationshipRepresentationTest.relrep(1234L).startNodeUri());
    }

    @Test
    void shouldHaveEndNodeLink() {
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", RelationshipRepresentationTest.relrep(1234L).endNodeUri());
    }

    @Test
    void shouldHavePropertiesLink() {
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+/properties", RelationshipRepresentationTest.relrep(1234L).propertiesUri());
    }

    @Test
    void shouldHavePropertyLinkTemplate() {
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+/properties/\\{key\\}", RelationshipRepresentationTest.relrep(1234L).propertyUriTemplate());
    }

    @Test
    void shouldSerialiseToMap() {
        Map<String, Object> repr = RepresentationTestAccess.serialize((MappingRepresentation)RelationshipRepresentationTest.relrep(1234L));
        Assertions.assertNotNull(repr);
        RelationshipRepresentationTest.verifySerialisation(repr);
    }

    private static RelationshipRepresentation relrep(long id) {
        return new RelationshipRepresentation(GraphMock.relationship((long)id, (Node)GraphMock.node((long)0L, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[0]), (String)"LOVES", (Node)GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[0]), (Property[])new Property[0]));
    }

    static void verifySerialisation(Map<String, Object> relrep) {
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+", relrep.get("self").toString());
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", relrep.get("start").toString());
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", relrep.get("end").toString());
        Assertions.assertNotNull((Object)relrep.get("type"));
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+/properties", relrep.get("properties").toString());
        RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+/properties/\\{key\\}", (String)relrep.get("property"));
        Assertions.assertNotNull((Object)relrep.get("data"));
        Assertions.assertNotNull((Object)relrep.get("metadata"));
        Map metadata = (Map)relrep.get("metadata");
        Assertions.assertNotNull(metadata.get("type"));
        Assertions.assertTrue((((Number)metadata.get("id")).longValue() >= 0L ? 1 : 0) != 0);
    }
}

