/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.rest.repr.ExceptionRepresentation;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.MapRepresentation;
import org.neo4j.server.rest.repr.MediaTypeNotSupportedException;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class RepresentationFormatRepositoryTest {
    private final RepresentationFormatRepository repository = new RepresentationFormatRepository();

    @Test
    public void canProvideJsonFormat() {
        Assertions.assertNotNull((Object)this.repository.inputFormat(MediaType.valueOf((String)"application/json")));
    }

    @Test
    public void canProvideUTF8EncodedJsonFormat() {
        Assertions.assertNotNull((Object)this.repository.inputFormat(MediaType.valueOf((String)"application/json;charset=UTF-8")));
    }

    @Test
    public void canNotGetInputFormatBasedOnWildcardMediaType() {
        InputFormat format = this.repository.inputFormat(MediaType.WILDCARD_TYPE);
        Assertions.assertThrows(MediaTypeNotSupportedException.class, () -> format.readValue("foo"));
    }

    @Test
    public void canProvideJsonOutputFormat() {
        OutputFormat format = this.repository.outputFormat(Collections.singletonList(MediaType.APPLICATION_JSON_TYPE), null, null);
        Assertions.assertNotNull((Object)format);
        Assertions.assertEquals((Object)"\"test\"", (Object)format.assemble((Representation)ValueRepresentation.string((String)"test")));
    }

    @Test
    public void cannotProvideStreamingForOtherMediaTypes() throws Exception {
        Response.ResponseBuilder responseBuilder = (Response.ResponseBuilder)Mockito.mock(Response.ResponseBuilder.class);
        Mockito.when((Object)responseBuilder.entity(ArgumentMatchers.any(byte[].class))).thenReturn((Object)responseBuilder);
        ((Response.ResponseBuilder)Mockito.verify((Object)responseBuilder, (VerificationMode)Mockito.never())).entity(ArgumentMatchers.isA(StreamingOutput.class));
        Mockito.when((Object)responseBuilder.type((MediaType)ArgumentMatchers.any())).thenReturn((Object)responseBuilder);
        Mockito.when((Object)responseBuilder.build()).thenReturn(null);
        OutputFormat format = this.repository.outputFormat(Collections.singletonList(MediaType.TEXT_HTML_TYPE), new URI("http://some.host"), RepresentationFormatRepositoryTest.streamingHeader());
        Assertions.assertNotNull((Object)format);
        format.response(responseBuilder, (Representation)new ExceptionRepresentation((Throwable)new RuntimeException()));
    }

    @Test
    public void canProvideStreamingJsonOutputFormat() throws Exception {
        Response response = (Response)Mockito.mock(Response.class);
        AtomicReference<StreamingOutput> ref = new AtomicReference<StreamingOutput>();
        Response.ResponseBuilder responseBuilder = RepresentationFormatRepositoryTest.mockResponseBuilder(response, ref);
        OutputFormat format = this.repository.outputFormat(Collections.singletonList(MediaType.APPLICATION_JSON_TYPE), null, RepresentationFormatRepositoryTest.streamingHeader());
        Assertions.assertNotNull((Object)format);
        Response returnedResponse = format.response(responseBuilder, (Representation)new MapRepresentation(MapUtil.map((Object[])new Object[]{"a", "test"})));
        Assertions.assertSame((Object)response, (Object)returnedResponse);
        StreamingOutput streamingOutput = ref.get();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        streamingOutput.write((OutputStream)baos);
        Assertions.assertEquals((Object)"{\"a\":\"test\"}", (Object)baos.toString());
    }

    private static Response.ResponseBuilder mockResponseBuilder(Response response, AtomicReference<StreamingOutput> ref) {
        Response.ResponseBuilder responseBuilder = (Response.ResponseBuilder)Mockito.mock(Response.ResponseBuilder.class);
        Mockito.when((Object)responseBuilder.entity(ArgumentMatchers.isA(StreamingOutput.class))).thenAnswer(invocationOnMock -> {
            ref.set((StreamingOutput)invocationOnMock.getArgument(0));
            return responseBuilder;
        });
        Mockito.when((Object)responseBuilder.type((MediaType)ArgumentMatchers.any())).thenReturn((Object)responseBuilder);
        Mockito.when((Object)responseBuilder.build()).thenReturn((Object)response);
        return responseBuilder;
    }

    private static MultivaluedMap<String, String> streamingHeader() {
        MultivaluedMap headers = (MultivaluedMap)Mockito.mock(MultivaluedMap.class);
        Mockito.when((Object)((String)headers.getFirst((Object)"X-Stream"))).thenReturn((Object)"true");
        return headers;
    }
}

