/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.rule.SuppressOutput;

@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class JettyThreadLimitIT {
    @Inject
    private SuppressOutput suppressOutput;

    JettyThreadLimitIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHaveConfigurableJettyThreadPoolSize() throws Exception {
        Jetty9WebServer server = new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), Config.defaults(), NetworkConnectionTracker.NO_OP, (ByteBufferPool)Mockito.mock(ByteBufferPool.class));
        int numCores = 1;
        int configuredMaxThreads = 12;
        int acceptorThreads = 1;
        int selectorThreads = 1;
        int jobThreads = configuredMaxThreads - acceptorThreads - selectorThreads;
        server.setMaxThreads(numCores);
        server.setHttpAddress(new SocketAddress("localhost", 0));
        try {
            server.start();
            QueuedThreadPool threadPool = (QueuedThreadPool)server.getJetty().getThreadPool();
            threadPool.start();
            CountDownLatch startLatch = new CountDownLatch(jobThreads);
            CountDownLatch endLatch = JettyThreadLimitIT.loadThreadPool(threadPool, configuredMaxThreads + 1, startLatch);
            startLatch.await();
            int threads = threadPool.getThreads();
            Assertions.assertEquals((int)configuredMaxThreads, (int)threads, (String)"Wrong number of threads in pool");
            endLatch.countDown();
        }
        finally {
            server.stop();
        }
    }

    private static CountDownLatch loadThreadPool(QueuedThreadPool threadPool, int tasksToSubmit, CountDownLatch startLatch) {
        CountDownLatch endLatch = new CountDownLatch(1);
        for (int i = 0; i < tasksToSubmit; ++i) {
            threadPool.execute(() -> {
                startLatch.countDown();
                try {
                    endLatch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
        }
        return endLatch;
    }
}

