/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.consumer;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.TransactionIndependentValueMapper;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;

public class OutputEventStreamRecordConsumer
implements BoltResult.RecordConsumer {
    private final BoltResult boltResult;
    private final OutputEventStream outputEventStream;
    private final Supplier<Map<String, Object>> resultsSupplier;
    private final TransactionIndependentValueMapper valueMapper;
    private Map<String, Object> results;
    private Map<String, AnyValue> metadataMap;
    private int fieldIndex;

    OutputEventStreamRecordConsumer(BoltResult boltResult, OutputEventStream outputEventStream, TransactionIndependentValueMapper valueMapper) {
        this(boltResult, outputEventStream, valueMapper, HashMap::new);
    }

    protected OutputEventStreamRecordConsumer(BoltResult boltResult, OutputEventStream outputEventStream, TransactionIndependentValueMapper valueMapper, Supplier<Map<String, Object>> resultsSupplier) {
        this.boltResult = boltResult;
        this.outputEventStream = outputEventStream;
        this.valueMapper = valueMapper;
        this.resultsSupplier = resultsSupplier;
        this.results = resultsSupplier.get();
        this.metadataMap = new HashMap<String, AnyValue>();
    }

    public void addMetadata(String key, AnyValue value) {
        this.metadataMap.put(key, value);
    }

    public void beginRecord(int numberOfFields) throws IOException {
        this.fieldIndex = 0;
        this.results = this.resultsSupplier.get();
        this.metadataMap = new HashMap<String, AnyValue>();
    }

    public void consumeField(AnyValue value) throws IOException {
        this.results.put(this.boltResult.fieldNames()[this.fieldIndex], value.map((ValueMapper)this.valueMapper));
        ++this.fieldIndex;
    }

    public void endRecord() throws IOException {
        this.outputEventStream.writeRecord(Arrays.asList((String[])this.boltResult.fieldNames().clone()), this.results::get);
    }

    public void onError() throws IOException {
        throw new IOException("An error occurred whilst processing query results");
    }

    public Map<String, AnyValue> metadataMap() {
        return this.metadataMap;
    }
}

