/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.eventsource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.neo4j.server.http.cypher.format.api.ConnectionException;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.api.StatementEndEvent;
import org.neo4j.server.http.cypher.format.api.StatementStartEvent;
import org.neo4j.server.http.cypher.format.api.TransactionInfoEvent;
import org.neo4j.server.http.cypher.format.input.json.InputStatement;
import org.neo4j.server.http.cypher.format.output.eventsource.LineDelimitedEventSourceJoltSerializer;

public class SequentialEventSourceJoltSerializer
extends LineDelimitedEventSourceJoltSerializer {
    private static final byte RECORD_SEPARATOR = 30;

    public SequentialEventSourceJoltSerializer(Map<String, Object> parameters, Class<? extends ObjectCodec> classOfCodec, boolean isStrictMode, JsonFactory jsonFactory, OutputStream output) {
        super(parameters, classOfCodec, isStrictMode, jsonFactory, output);
    }

    private void writeRecordSeparator() {
        try {
            this.output.write(30);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to write to the connection", e);
        }
    }

    @Override
    protected void writeStatementStart(StatementStartEvent statementStartEvent, InputStatement inputStatement) {
        this.writeRecordSeparator();
        super.writeStatementStart(statementStartEvent, inputStatement);
    }

    @Override
    protected void writeStatementEnd(StatementEndEvent statementEndEvent) {
        this.writeRecordSeparator();
        super.writeStatementEnd(statementEndEvent);
    }

    @Override
    protected void writeRecord(RecordEvent recordEvent) {
        this.writeRecordSeparator();
        super.writeRecord(recordEvent);
    }

    @Override
    protected void writeTransactionInfo(TransactionInfoEvent transactionInfoEvent) {
        this.writeRecordSeparator();
        super.writeTransactionInfo(transactionInfoEvent);
    }

    @Override
    protected void writeErrorWrapper() {
        if (this.errors.isEmpty()) {
            return;
        }
        this.writeRecordSeparator();
        super.writeErrorWrapper();
    }
}

