/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.server.http.cypher.entity.HttpNode;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.repr.RepresentationTestBase;

class NodeRepresentationTest {
    NodeRepresentationTest() {
    }

    @Test
    void shouldHaveSelfLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern(""), NodeRepresentationTest.noderep(1234L).selfUri());
    }

    @Test
    void shouldHaveAllRelationshipsLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/all"), NodeRepresentationTest.noderep(1234L).allRelationshipsUri());
    }

    @Test
    void shouldHaveIncomingRelationshipsLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/in"), NodeRepresentationTest.noderep(1234L).incomingRelationshipsUri());
    }

    @Test
    void shouldHaveOutgoingRelationshipsLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/out"), NodeRepresentationTest.noderep(1234L).outgoingRelationshipsUri());
    }

    @Test
    void shouldHaveAllTypedRelationshipsLinkTemplate() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/all/\\{-list\\|&\\|types\\}"), NodeRepresentationTest.noderep(1234L).allTypedRelationshipsUriTemplate());
    }

    @Test
    void shouldHaveIncomingTypedRelationshipsLinkTemplate() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/in/\\{-list\\|&\\|types\\}"), NodeRepresentationTest.noderep(1234L).incomingTypedRelationshipsUriTemplate());
    }

    @Test
    void shouldHaveOutgoingTypedRelationshipsLinkTemplate() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/out/\\{-list\\|&\\|types\\}"), NodeRepresentationTest.noderep(1234L).outgoingTypedRelationshipsUriTemplate());
    }

    @Test
    void shouldHaveRelationshipCreationLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships"), NodeRepresentationTest.noderep(1234L).relationshipCreationUri());
    }

    @Test
    void shouldHavePropertiesLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/properties"), NodeRepresentationTest.noderep(1234L).propertiesUri());
    }

    @Test
    void shouldHavePropertyLinkTemplate() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/properties/\\{key\\}"), NodeRepresentationTest.noderep(1234L).propertyUriTemplate());
    }

    @Test
    void shouldHaveTraverseLinkTemplate() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/traverse/\\{returnType\\}"), NodeRepresentationTest.noderep(1234L).traverseUriTemplate());
    }

    @Test
    void shouldSerialiseToMap() {
        Map<String, Object> repr = RepresentationTestAccess.serialize((MappingRepresentation)NodeRepresentationTest.noderep(1234L));
        Assertions.assertNotNull(repr);
        NodeRepresentationTest.verifySerialisation(repr);
    }

    @Test
    void shouldHaveLabelsLink() {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/labels"), NodeRepresentationTest.noderep(1234L).labelsUriTemplate());
    }

    private static NodeRepresentation noderep(long id) {
        return new NodeRepresentation((Node)new HttpNode(id, List.of(Label.label((String)"Label")), Collections.emptyMap(), false));
    }

    static void verifySerialisation(Map<String, Object> noderep) {
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern(""), noderep.get("self").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships"), noderep.get("create_relationship").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/all"), noderep.get("all_relationships").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/in"), noderep.get("incoming_relationships").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/out"), noderep.get("outgoing_relationships").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/all/\\{-list\\|&\\|types\\}"), (String)noderep.get("all_typed_relationships"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/in/\\{-list\\|&\\|types\\}"), (String)noderep.get("incoming_typed_relationships"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/relationships/out/\\{-list\\|&\\|types\\}"), (String)noderep.get("outgoing_typed_relationships"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/properties"), noderep.get("properties").toString());
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/properties/\\{key\\}"), (String)noderep.get("property"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/traverse/\\{returnType\\}"), (String)noderep.get("traverse"));
        RepresentationTestBase.assertUriMatches(RepresentationTestBase.uriPattern("/labels"), (String)noderep.get("labels"));
        Assertions.assertNotNull((Object)noderep.get("data"));
        Map metadata = (Map)noderep.get("metadata");
        List labels = (List)metadata.get("labels");
        Assertions.assertTrue((labels.isEmpty() || labels.equals(Arrays.asList("Label")) ? 1 : 0) != 0);
        Assertions.assertTrue((((Number)metadata.get("id")).longValue() >= 0L ? 1 : 0) != 0);
    }
}

