/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.discovery.DiscoverableURIs;

class DiscoverableURIsTest {
    private final BiConsumer<String, String> consumer = (BiConsumer)Mockito.mock(BiConsumer.class);
    private final ConnectorPortRegister portRegister = (ConnectorPortRegister)Mockito.mock(ConnectorPortRegister.class);

    DiscoverableURIsTest() {
    }

    @Test
    void shouldNotInvokeConsumerWhenEmpty() {
        DiscoverableURIs empty = new DiscoverableURIs.Builder(null).build();
        empty.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer, (VerificationMode)Mockito.never())).accept(ArgumentMatchers.anyString(), (String)ArgumentMatchers.any());
    }

    @Test
    void shouldInvokeConsumerForEachKey() {
        DiscoverableURIs discoverables = new DiscoverableURIs.Builder(null).addEndpoint("a", "/test").addEndpoint("b", "/data").addEndpoint("c", "/{name}/data").build();
        discoverables.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer)).accept("a", "/test");
        ((BiConsumer)Mockito.verify(this.consumer)).accept("b", "/data");
        ((BiConsumer)Mockito.verify(this.consumer)).accept("c", "/{name}/data");
    }

    @Test
    void shouldSetBoltPort() {
        Config config = DiscoverableURIsTest.configWithBoltEnabled();
        DiscoverableURIs discoverables = new DiscoverableURIs.Builder(null).addBoltEndpoint(config, this.portRegister).build();
        discoverables.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_direct", "bolt://localhost:7687");
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_routing", "neo4j://localhost:7687");
    }

    @Test
    void shouldLookupBoltPort() {
        Config config = Config.newBuilder().set(Map.of(BoltConnector.enabled, true, BoltConnector.advertised_address, new SocketAddress(0))).build();
        ConnectorPortRegister register = new ConnectorPortRegister();
        register.register("bolt", new InetSocketAddress(1337));
        DiscoverableURIs discoverables = new DiscoverableURIs.Builder(null).addBoltEndpoint(config, register).build();
        discoverables.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_direct", "bolt://localhost:1337");
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_routing", "neo4j://localhost:1337");
    }

    @Test
    void shouldSetBoltHostAndPortWithDefaultAdvertisedAddress() {
        Config config = Config.newBuilder().set(Map.of(BoltConnector.enabled, true, GraphDatabaseSettings.default_advertised_address, new SocketAddress("myCat.com"))).build();
        DiscoverableURIs discoverables = new DiscoverableURIs.Builder(null).addBoltEndpoint(config, this.portRegister).build();
        discoverables.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_direct", "bolt://myCat.com:7687");
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_routing", "neo4j://myCat.com:7687");
    }

    @Test
    void shouldNotSetBoltHostWhenHostIsNotExplicitlySet() {
        Config config = Config.newBuilder().set(Map.of(BoltConnector.enabled, true, BoltConnector.advertised_address, new SocketAddress(1234))).build();
        DiscoverableURIs discoverables = new DiscoverableURIs.Builder(null).addBoltEndpoint(config, this.portRegister).build();
        discoverables.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_direct", "bolt://localhost:1234");
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_routing", "neo4j://localhost:1234");
    }

    @Test
    void shouldSetBoltHostWhenHostIsExplicitlySet() {
        Config config = Config.newBuilder().set(Map.of(BoltConnector.enabled, true, BoltConnector.advertised_address, new SocketAddress("myCat.com", 1234))).build();
        DiscoverableURIs discoverables = new DiscoverableURIs.Builder(null).addBoltEndpoint(config, this.portRegister).build();
        discoverables.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_direct", "bolt://myCat.com:1234");
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_routing", "neo4j://myCat.com:1234");
    }

    @Test
    void shouldOverrideBoltHostWhenHostIsExplicitlySet() {
        Config config = Config.newBuilder().set(Map.of(BoltConnector.enabled, true, GraphDatabaseSettings.default_advertised_address, new SocketAddress("myDog.com"), BoltConnector.advertised_address, new SocketAddress("myCat.com", 1234))).build();
        DiscoverableURIs discoverables = new DiscoverableURIs.Builder(null).addBoltEndpoint(config, this.portRegister).build();
        discoverables.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_direct", "bolt://myCat.com:1234");
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_routing", "neo4j://myCat.com:1234");
    }

    @Test
    void shouldOverrideBoltEndpoints() {
        Config config = Config.newBuilder().set(Map.of(BoltConnector.enabled, true, GraphDatabaseSettings.default_advertised_address, new SocketAddress("myDog.com"), BoltConnector.advertised_address, new SocketAddress("myCat.com", 1234), ServerSettings.bolt_discoverable_address, URI.create("dog://myDog.com"), ServerSettings.bolt_routing_discoverable_address, URI.create("cat://myCat.com"))).build();
        DiscoverableURIs discoverables = new DiscoverableURIs.Builder(null).addBoltEndpoint(config, this.portRegister).build();
        discoverables.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_direct", "dog://myDog.com");
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_routing", "cat://myCat.com");
    }

    @Test
    void shouldUpdateAllUnsetFields() {
        Config config = Config.newBuilder().set(Map.of(BoltConnector.enabled, true, ServerSettings.bolt_discoverable_address, URI.create("dog://myDog.com"))).build();
        DiscoverableURIs discoverables = new DiscoverableURIs.Builder(null).addEndpoint("a", "/test").addEndpoint("b", "/{name}/data").addBoltEndpoint(config, this.portRegister).build();
        discoverables.update(URI.create("cat://myCat.com:1234"));
        discoverables.forEach(this.consumer);
        ((BiConsumer)Mockito.verify(this.consumer)).accept("a", "cat://myCat.com:1234/test");
        ((BiConsumer)Mockito.verify(this.consumer)).accept("b", "cat://myCat.com:1234/{name}/data");
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_direct", "dog://myDog.com");
        ((BiConsumer)Mockito.verify(this.consumer)).accept("bolt_routing", "neo4j://myCat.com:7687");
    }

    private static Config configWithBoltEnabled() {
        return Config.newBuilder().set(BoltConnector.enabled, (Object)true).build();
    }
}

