/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.neo4j.configuration.Config;
import org.neo4j.server.NeoWebServer;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.rest.discovery.ServerVersionAndEdition;
import org.neo4j.server.rest.repr.DiscoveryRepresentation;

@Path(value="/")
public class DiscoveryService {
    private final Config config;
    private final DiscoverableURIs uris;
    private final ServerVersionAndEdition serverInfo;
    private final AuthConfigProvider authConfigProvider;

    public DiscoveryService(@Context Config config, @Context DiscoverableURIs uris, @Context NeoWebServer neoWebServer, @Context AuthConfigProvider authConfigProvider) {
        this(config, uris, new ServerVersionAndEdition(neoWebServer), authConfigProvider);
    }

    DiscoveryService(Config config, DiscoverableURIs uris, ServerVersionAndEdition serverInfo, AuthConfigProvider authConfigProvider) {
        this.config = config;
        this.uris = uris;
        this.serverInfo = serverInfo;
        this.authConfigProvider = authConfigProvider;
    }

    @GET
    @Produces(value={"*/*"})
    public Response get(@Context Request request, @Context UriInfo uriInfo) {
        Variant v = request.selectVariant(Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_HTML_TYPE}).build());
        Response.ResponseBuilder responseBuilder = v == null ? Response.serverError().status(Response.Status.NOT_ACCEPTABLE) : (v.getMediaType() == MediaType.APPLICATION_JSON_TYPE ? Response.ok().entity((Object)new DiscoveryRepresentation(this.uris.update(uriInfo.getBaseUri()), this.serverInfo, this.authConfigProvider.getRepresentation())).variant(v) : Response.seeOther((URI)uriInfo.getBaseUri().resolve((URI)this.config.get(ServerSettings.browser_path))).variant(v));
        return responseBuilder.build();
    }
}

