/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.server.http.cypher.format.jolt.JoltModule;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class JoltSerializerTest {
    private final ObjectMapper objectMapper = new ObjectMapper();

    JoltSerializerTest() {
        this.objectMapper.registerModule((Module)JoltModule.STRICT.getInstance());
    }

    public void assertValidJSON(String json) {
        try {
            this.objectMapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            Assertions.fail((String)"Invalid JSON: ", (Object[])new Object[]{json});
        }
    }

    @Nested
    @ExtendWith(value={MockitoExtension.class})
    class Entities {
        Entities() {
        }

        @Test
        void shouldSerializeNode(@Mock Node node) throws JsonProcessingException {
            Mockito.when((Object)node.getId()).thenReturn((Object)4711L);
            Mockito.when((Object)node.getLabels()).thenReturn(List.of(Label.label((String)"A"), Label.label((String)"B")));
            Mockito.when((Object)node.getAllProperties()).thenReturn(new TreeMap<String, String>(Map.of("prop1", 1, "prop2", "Peng")));
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)node);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"()\":[4711,[\"A\",\"B\"],{\"prop1\":{\"Z\":\"1\"},\"prop2\":{\"U\":\"Peng\"}}]}");
        }

        @Test
        void shouldSerializeNodeWithoutLabelsOrProperties(@Mock Node node) throws JsonProcessingException {
            Mockito.when((Object)node.getId()).thenReturn((Object)4711L);
            Mockito.when((Object)node.getLabels()).thenReturn(List.of());
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)node);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"()\":[4711,[],{}]}");
        }

        @Test
        void shouldSerializeRelationship(@Mock Relationship relationship) throws JsonProcessingException {
            Mockito.when((Object)relationship.getId()).thenReturn((Object)4711L);
            Mockito.when((Object)relationship.getType()).thenReturn((Object)RelationshipType.withName((String)"KNOWS"));
            Mockito.when((Object)relationship.getStartNodeId()).thenReturn((Object)123L);
            Mockito.when((Object)relationship.getEndNodeId()).thenReturn((Object)124L);
            Mockito.when((Object)relationship.getAllProperties()).thenReturn(Map.of("since", 1999));
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)relationship);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"->\":[4711,123,\"KNOWS\",124,{\"since\":{\"Z\":\"1999\"}}]}");
        }

        @Test
        void shouldSerializePath(@Mock Path path, @Mock Node start, @Mock Relationship rel, @Mock Node end) throws JsonProcessingException {
            Mockito.when((Object)start.getId()).thenReturn((Object)111L);
            Mockito.when((Object)start.getLabels()).thenReturn(List.of());
            Mockito.when((Object)end.getId()).thenReturn((Object)222L);
            Mockito.when((Object)end.getLabels()).thenReturn(List.of());
            Mockito.when((Object)rel.getId()).thenReturn((Object)9090L);
            Mockito.when((Object)rel.getType()).thenReturn((Object)RelationshipType.withName((String)"KNOWS"));
            Mockito.when((Object)rel.getStartNodeId()).thenReturn((Object)111L);
            Mockito.when((Object)rel.getEndNodeId()).thenReturn((Object)222L);
            Mockito.when((Object)rel.getAllProperties()).thenReturn(Map.of("since", 1999));
            List<Node> pathList = List.of(start, rel, end);
            Mockito.when((Object)path.iterator()).thenReturn(pathList.iterator());
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)path);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"..\":[{\"()\":[111,[],{}]},{\"->\":[9090,111,\"KNOWS\",222,{\"since\":{\"Z\":\"1999\"}}]},{\"()\":[222,[],{}]}]}");
        }

        @Test
        void shouldSerializeReversedPath(@Mock Path path, @Mock Node start, @Mock Relationship rel, @Mock Node end) throws JsonProcessingException {
            Mockito.when((Object)start.getId()).thenReturn((Object)111L);
            Mockito.when((Object)start.getLabels()).thenReturn(List.of());
            Mockito.when((Object)end.getId()).thenReturn((Object)222L);
            Mockito.when((Object)end.getLabels()).thenReturn(List.of());
            Mockito.when((Object)rel.getId()).thenReturn((Object)9090L);
            Mockito.when((Object)rel.getType()).thenReturn((Object)RelationshipType.withName((String)"KNOWS"));
            Mockito.when((Object)rel.getStartNodeId()).thenReturn((Object)222L);
            Mockito.when((Object)rel.getEndNodeId()).thenReturn((Object)111L);
            Mockito.when((Object)rel.getAllProperties()).thenReturn(Map.of("since", 1999));
            List<Node> pathList = List.of(start, rel, end);
            Mockito.when((Object)path.iterator()).thenReturn(pathList.iterator());
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)path);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"..\":[{\"()\":[111,[],{}]},{\"<-\":[9090,111,\"KNOWS\",222,{\"since\":{\"Z\":\"1999\"}}]},{\"()\":[222,[],{}]}]}");
        }

        @Test
        void shouldSerializeLongPath(@Mock Path path, @Mock Node start, @Mock Relationship relA, @Mock Node middle, @Mock Relationship relB, @Mock Node end) throws JsonProcessingException {
            Mockito.when((Object)start.getId()).thenReturn((Object)111L);
            Mockito.when((Object)start.getLabels()).thenReturn(List.of());
            Mockito.when((Object)middle.getId()).thenReturn((Object)222L);
            Mockito.when((Object)middle.getLabels()).thenReturn(List.of());
            Mockito.when((Object)end.getId()).thenReturn((Object)333L);
            Mockito.when((Object)end.getLabels()).thenReturn(List.of());
            Mockito.when((Object)relA.getId()).thenReturn((Object)9090L);
            Mockito.when((Object)relA.getType()).thenReturn((Object)RelationshipType.withName((String)"KNOWS"));
            Mockito.when((Object)relA.getStartNodeId()).thenReturn((Object)111L);
            Mockito.when((Object)relA.getEndNodeId()).thenReturn((Object)222L);
            Mockito.when((Object)relA.getAllProperties()).thenReturn(Map.of("since", 1999));
            Mockito.when((Object)relB.getId()).thenReturn((Object)9090L);
            Mockito.when((Object)relB.getType()).thenReturn((Object)RelationshipType.withName((String)"KNOWS"));
            Mockito.when((Object)relB.getStartNodeId()).thenReturn((Object)333L);
            Mockito.when((Object)relB.getEndNodeId()).thenReturn((Object)222L);
            Mockito.when((Object)relB.getAllProperties()).thenReturn(Map.of("since", 1990));
            List<Node> pathList = List.of(start, relA, middle, relB, end);
            Mockito.when((Object)path.iterator()).thenReturn(pathList.iterator());
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)path);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"..\":[{\"()\":[111,[],{}]},{\"->\":[9090,111,\"KNOWS\",222,{\"since\":{\"Z\":\"1999\"}}]},{\"()\":[222,[],{}]},{\"<-\":[9090,222,\"KNOWS\",333,{\"since\":{\"Z\":\"1990\"}}]},{\"()\":[333,[],{}]}]}");
        }
    }

    @Nested
    class Collections {
        Collections() {
        }

        @Test
        void shouldSerializeArrays() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)new String[]{"A", "B"});
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("[{\"U\":\"A\"},{\"U\":\"B\"}]");
        }

        @Test
        void shouldSerializeHomogenousList() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"[]\":[{\"Z\":\"1\"},{\"Z\":\"2\"},{\"Z\":\"3\"}]}");
        }

        @Test
        void shouldSerializeHeterogeneousList() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString(List.of("A", Integer.valueOf(21), Double.valueOf(42.3)));
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"[]\":[{\"U\":\"A\"},{\"Z\":\"21\"},{\"R\":\"42.3\"}]}");
        }

        @Test
        void shouldSerializeMap() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString(new TreeMap<String, Integer>(Map.of("name", "Alice", "age", 33)));
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"{}\":{\"age\":{\"Z\":\"33\"},\"name\":{\"U\":\"Alice\"}}}");
        }
    }

    @Nested
    class Arrays {
        Arrays() {
        }

        @Test
        void shouldSerializeLongArray() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)new Long[]{0L, 1L, 2L});
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("[{\"Z\":\"0\"},{\"Z\":\"1\"},{\"Z\":\"2\"}]");
        }

        @Test
        void shouldSerializeByteArray() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)new byte[]{0, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16});
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"#\":\"0001020304050608090A0B0C0D0E0F10\"}");
        }
    }

    @Nested
    class DateTimeDuration {
        DateTimeDuration() {
        }

        @Test
        void shouldSerializeDuration() throws JsonProcessingException {
            DurationValue duration = DurationValue.duration((Duration)Duration.ofDays(20L));
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)duration);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"T\":\"PT480H\"}");
        }

        @Test
        void shouldSerializeLargeDuration() throws JsonProcessingException {
            String durationString = "P3Y6M4DT12H30M5S";
            DurationValue durationValue = DurationValue.parse((CharSequence)durationString);
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)durationValue);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"T\":\"" + durationString + "\"}");
        }

        @Test
        void shouldSerializeDate() throws JsonProcessingException {
            String dateString = "2020-08-25";
            LocalDate date = LocalDate.parse(dateString);
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)date);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"T\":\"" + dateString + "\"}");
        }

        @Test
        void shouldSerializeTime() throws JsonProcessingException {
            String timeString = "12:52:58.513775";
            LocalTime time = LocalTime.parse(timeString);
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)time);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"T\":\"" + timeString + "\"}");
        }

        @Test
        void shouldSerializeOffsetTime() throws JsonProcessingException {
            String offsetTimeString = "12:55:10.775607+01:00";
            OffsetTime time = OffsetTime.parse(offsetTimeString);
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)time);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"T\":\"" + offsetTimeString + "\"}");
        }

        @Test
        void shouldSerializeLocalDateTime() throws JsonProcessingException {
            String localDateTimeString = "2020-08-25T12:57:36.069665";
            LocalDateTime dateTime = LocalDateTime.parse(localDateTimeString);
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)dateTime);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"T\":\"" + localDateTimeString + "\"}");
        }

        @Test
        void shouldSerializeZonedDateTime() throws JsonProcessingException {
            String zonedDateTimeString = "2020-08-25T13:03:39.11733+01:00[Europe/London]";
            ZonedDateTime dateTime = ZonedDateTime.parse(zonedDateTimeString);
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)dateTime);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"T\":\"" + zonedDateTimeString + "\"}");
        }
    }

    @Nested
    class SimpleTypes {
        SimpleTypes() {
        }

        @Test
        void shouldSerializeNull() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString(null);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("null");
        }

        @Test
        void shouldSerializeInteger() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)123);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"Z\":\"123\"}");
        }

        @Test
        void shouldSerializeBoolean() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)true);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"?\":\"true\"}");
        }

        @Test
        void shouldSerializeLongInsideInt32Range() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)123L);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"Z\":\"123\"}");
        }

        @Test
        void shouldSerializeLongAboveInt32Range() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)0x80000000L);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"R\":\"2147483648\"}");
        }

        @Test
        void shouldSerializeLongBelowInt32Range() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)-2147483649L);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"R\":\"-2147483649\"}");
        }

        @Test
        void shouldSerializeDouble() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)42.23);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"R\":\"42.23\"}");
        }

        @Test
        void shouldSerializeString() throws JsonProcessingException {
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)"Hello, World");
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"U\":\"Hello, World\"}");
        }

        @Test
        void shouldSerializePoint() throws JsonProcessingException {
            PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.994823, 55.612191});
            String result = JoltSerializerTest.this.objectMapper.writeValueAsString((Object)point);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("{\"@\":\"SRID=4326;POINT(12.994823 55.612191)\"}");
        }
    }

    @Nested
    class SparseMode {
        private ObjectMapper spareObjectMapper = new ObjectMapper();

        SparseMode() {
            this.spareObjectMapper.registerModule((Module)JoltModule.DEFAULT.getInstance());
        }

        @Test
        void shouldUseJSONString() throws JsonProcessingException {
            this.spareObjectMapper = new ObjectMapper();
            String result = this.spareObjectMapper.writeValueAsString((Object)"Hello, World");
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("\"Hello, World\"");
        }

        @Test
        void shouldUseJSONBoolean() throws JsonProcessingException {
            this.spareObjectMapper = new ObjectMapper();
            String result = this.spareObjectMapper.writeValueAsString((Object)true);
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("true");
        }

        @Test
        void shouldUseJSONList() throws JsonProcessingException {
            String result = this.spareObjectMapper.writeValueAsString(List.of(Integer.valueOf(1), Integer.valueOf(2), "3"));
            JoltSerializerTest.this.assertValidJSON(result);
            Assertions.assertThat((String)result).isEqualTo("[1,2,\"3\"]");
        }
    }
}

