/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.eventsource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.server.http.cypher.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.http.cypher.format.api.RecordEvent;
import org.neo4j.server.http.cypher.format.jolt.JoltCodec;
import org.neo4j.server.http.cypher.format.output.eventsource.AbstractEventSourceJoltSerializerTest;
import org.neo4j.server.http.cypher.format.output.eventsource.LineDelimitedEventSourceJoltSerializer;
import org.neo4j.server.http.cypher.format.output.eventsource.SequentialEventSourceJoltSerializer;

public class SequentialEventSourceJoltSerializerTest
extends AbstractEventSourceJoltSerializerTest {
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();
    private SequentialEventSourceJoltSerializer serializer;

    @BeforeEach
    void init() {
        TransitionalTxManagementKernelTransaction context = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
        InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        KernelTransactionImplementation kernelTransaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)internalTransaction.kernelTransaction()).thenReturn((Object)kernelTransaction);
        Mockito.when((Object)context.getInternalTransaction()).thenReturn((Object)internalTransaction);
        this.serializer = SequentialEventSourceJoltSerializerTest.getSerializerWith(this.output);
    }

    @Test
    void shouldSerializeWithRecordSeparator() {
        Map<String, String> row = Map.of("column1", "value1", "column2", "value2");
        SequentialEventSourceJoltSerializerTest.writeStatementStart((LineDelimitedEventSourceJoltSerializer)this.serializer, "column1", "column2");
        SequentialEventSourceJoltSerializerTest.writeRecord((LineDelimitedEventSourceJoltSerializer)this.serializer, row, "column1", "column2");
        RecordEvent recordEvent = (RecordEvent)Mockito.mock(RecordEvent.class);
        Mockito.when((Object)recordEvent.getValue((String)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("Stuff went wrong!")});
        Mockito.when((Object)recordEvent.getColumns()).thenReturn(List.of("column1", "column2"));
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.serializer.writeRecord(recordEvent));
        SequentialEventSourceJoltSerializerTest.writeError((LineDelimitedEventSourceJoltSerializer)this.serializer, (Status)Status.Statement.ExecutionFailed, e.getMessage());
        SequentialEventSourceJoltSerializerTest.writeTransactionInfo((LineDelimitedEventSourceJoltSerializer)this.serializer, "commit/uri/1");
        SequentialEventSourceJoltSerializerTest.writeStatementEnd((LineDelimitedEventSourceJoltSerializer)this.serializer);
        String result = this.output.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"\u001e{\"header\":{\"fields\":[\"column1\",\"column2\"]}}\n\u001e{\"data\":[{\"U\":\"value1\"},{\"U\":\"value2\"}]}\n\u001e{\"data\":[]}\n\u001e{\"error\":{\"errors\":[{\"code\":{\"U\":\"Neo.DatabaseError.Statement.ExecutionFailed\"},\"message\":{\"U\":\"Stuff went wrong!\"}}]}}\n\u001e{\"info\":{\"commit\":\"commit/uri/1\"}}\n\u001e{\"summary\":{}}\n", (Object)result);
    }

    protected static SequentialEventSourceJoltSerializer getSerializerWith(OutputStream output) {
        return new SequentialEventSourceJoltSerializer(Collections.emptyMap(), JoltCodec.class, true, JSON_FACTORY, output);
    }
}

