/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.logging.Log;

public class HttpHeaderUtils {
    public static final String MAX_EXECUTION_TIME_HEADER = "max-execution-time";
    public static final String ACCESS_MODE_HEADER = "access-mode";
    public static final Map<String, String> CHARSET = Map.of("charset", StandardCharsets.UTF_8.name());

    private HttpHeaderUtils() {
    }

    public static MediaType mediaTypeWithCharsetUtf8(MediaType mediaType) {
        Map parameters = mediaType.getParameters();
        if (parameters.isEmpty()) {
            return new MediaType(mediaType.getType(), mediaType.getSubtype(), CHARSET);
        }
        if (parameters.containsKey("charset")) {
            return mediaType;
        }
        HashMap<String, String> paramsWithCharset = new HashMap<String, String>(parameters);
        paramsWithCharset.putAll(CHARSET);
        return new MediaType(mediaType.getType(), mediaType.getSubtype(), paramsWithCharset);
    }

    public static long getTransactionTimeout(HttpServletRequest request, Log errorLog) {
        String headerValue = request.getHeader(MAX_EXECUTION_TIME_HEADER);
        return HttpHeaderUtils.getTransactionTimeout(headerValue, errorLog);
    }

    public static long getTransactionTimeout(HttpHeaders headers, Log errorLog) {
        String headerValue = headers.getHeaderString(MAX_EXECUTION_TIME_HEADER);
        return HttpHeaderUtils.getTransactionTimeout(headerValue, errorLog);
    }

    public static Optional<Boolean> getAccessMode(HttpHeaders headers) {
        String headerValue = headers.getHeaderString(ACCESS_MODE_HEADER);
        if (headerValue == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(AccessMode.valueOf((String)headerValue.toUpperCase()).equals((Object)AccessMode.READ));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("The header '%s' should be either 'WRITE' or 'READ' but found '%s'.", ACCESS_MODE_HEADER, headerValue), ex);
        }
    }

    private static long getTransactionTimeout(String headerValue, Log errorLog) {
        if (headerValue != null) {
            try {
                return Long.parseLong(headerValue);
            }
            catch (NumberFormatException e) {
                errorLog.error(String.format("Fail to parse `%s` header with value: '%s'. Should be a positive number.", MAX_EXECUTION_TIME_HEADER, headerValue), (Throwable)e);
            }
        }
        return 0L;
    }

    public static boolean isValidHttpHeaderName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        boolean isBlank = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isISOControl(c)) {
                return false;
            }
            if (Character.isWhitespace(c)) continue;
            isBlank = false;
        }
        return !isBlank;
    }
}

