/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.procedure.builtin.routing.ClientRoutingDomainChecker;
import org.neo4j.procedure.builtin.routing.SimpleClientRoutingDomainChecker;
import org.neo4j.server.configuration.ConfigurableServerModules;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.discovery.CommunityDiscoverableURIs;
import org.neo4j.server.rest.discovery.DiscoverableURIs;

class CommunityDiscoverableURIsTest {
    CommunityDiscoverableURIsTest() {
    }

    @Test
    void shouldAdvertiseTransactionAndManagementURIs() {
        DiscoverableURIs uris = CommunityDiscoverableURIs.communityDiscoverableURIs((Config)Config.defaults(), null, null);
        Assertions.assertEquals(Map.of("transaction", "/db/{databaseName}/tx"), CommunityDiscoverableURIsTest.toMap(uris));
    }

    @Test
    void shouldNotAdvertiseDisabledTransactionAndManagementURIs() {
        DiscoverableURIs uris = CommunityDiscoverableURIs.communityDiscoverableURIs((Config)Config.defaults((Setting)ServerSettings.http_enabled_modules, EnumSet.complementOf(EnumSet.of(ConfigurableServerModules.TRANSACTIONAL_ENDPOINTS))), null, null);
        Assertions.assertEquals(Map.of(), CommunityDiscoverableURIsTest.toMap(uris));
    }

    @Test
    void shouldAdvertiseBoltIfExplicitlyConfigured() {
        DiscoverableURIs uris = CommunityDiscoverableURIs.communityDiscoverableURIs((Config)Config.newBuilder().set(BoltConnector.enabled, (Object)true).set(ServerSettings.bolt_discoverable_address, (Object)URI.create("bolt://banana.com:1234")).build(), null, null);
        Map<String, String> map = CommunityDiscoverableURIsTest.toMap(uris);
        Assertions.assertEquals((Object)"bolt://banana.com:1234", (Object)map.get("bolt_direct"));
        Assertions.assertEquals((Object)"neo4j://localhost:7687", (Object)map.get("bolt_routing"));
    }

    @Test
    void shouldAdvertiseBoltOnBaseURIIfServerSideRoutingEnabled() {
        Config config = Config.newBuilder().set(BoltConnector.enabled, (Object)true).set(BoltConnector.advertised_address, (Object)new SocketAddress("banana.com", 1234)).set(GraphDatabaseSettings.routing_default_router, (Object)GraphDatabaseSettings.RoutingMode.SERVER).build();
        DiscoverableURIs uris = CommunityDiscoverableURIs.communityDiscoverableURIs((Config)config, null, (ClientRoutingDomainChecker)SimpleClientRoutingDomainChecker.fromConfig((Config)config, (LogProvider)NullLogProvider.getInstance()));
        Map<String, String> map = CommunityDiscoverableURIsTest.toMap(uris.update(URI.create("https://orange.org:8080")));
        Assertions.assertEquals((Object)"bolt://orange.org:1234", (Object)map.get("bolt_direct"));
        Assertions.assertEquals((Object)"neo4j://orange.org:1234", (Object)map.get("bolt_routing"));
    }

    @Test
    void shouldLookupBoltPortInRegisterIfConfigured() {
        ConnectorPortRegister register = new ConnectorPortRegister();
        register.register("bolt", new InetSocketAddress(1337));
        DiscoverableURIs uris = CommunityDiscoverableURIs.communityDiscoverableURIs((Config)Config.newBuilder().set(BoltConnector.advertised_address, (Object)new SocketAddress("apple.com", 0)).set(BoltConnector.enabled, (Object)true).build(), (ConnectorPortRegister)register, null);
        Map<String, String> map = CommunityDiscoverableURIsTest.toMap(uris);
        Assertions.assertEquals((Object)"bolt://apple.com:1337", (Object)map.get("bolt_direct"));
        Assertions.assertEquals((Object)"neo4j://apple.com:1337", (Object)map.get("bolt_routing"));
    }

    private static Map<String, String> toMap(DiscoverableURIs uris) {
        HashMap<String, String> out = new HashMap<String, String>();
        uris.forEach(out::put);
        return out;
    }
}

