/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.net.URI;
import java.net.URISyntaxException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.server.web.SimpleUriBuilder;

class SimpleUriBuilderTest {
    SimpleUriBuilderTest() {
    }

    @Test
    void shouldIncludeScheme() {
        URI uri1 = SimpleUriBuilder.buildURI((SocketAddress)new SocketAddress("neo4j.example.org", 443), (boolean)false);
        URI uri2 = SimpleUriBuilder.buildURI((SocketAddress)new SocketAddress("neo4j.example.org", 80), (boolean)true);
        Assertions.assertEquals((Object)"http", (Object)uri1.getScheme());
        Assertions.assertEquals((Object)"https", (Object)uri2.getScheme());
    }

    @Test
    void shouldIncludePortWhenNecessary() {
        URI uri1 = SimpleUriBuilder.buildURI((SocketAddress)new SocketAddress("neo4j.example.org", 80), (boolean)false);
        URI uri2 = SimpleUriBuilder.buildURI((SocketAddress)new SocketAddress("neo4j.example.org", 443), (boolean)true);
        URI uri3 = SimpleUriBuilder.buildURI((SocketAddress)new SocketAddress("neo4j.example.org", 443), (boolean)false);
        URI uri4 = SimpleUriBuilder.buildURI((SocketAddress)new SocketAddress("neo4j.example.org", 80), (boolean)true);
        URI uri5 = SimpleUriBuilder.buildURI((SocketAddress)new SocketAddress("neo4j.example.org", 7690), (boolean)false);
        Assertions.assertEquals((int)-1, (int)uri1.getPort());
        Assertions.assertEquals((int)-1, (int)uri2.getPort());
        Assertions.assertEquals((int)443, (int)uri3.getPort());
        Assertions.assertEquals((int)80, (int)uri4.getPort());
        Assertions.assertEquals((int)7690, (int)uri5.getPort());
    }

    @Test
    void shouldRejectInvalidHostnames() {
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> SimpleUriBuilder.buildURI((SocketAddress)new SocketAddress("$core_1", 443), (boolean)false));
        Throwable cause = ex.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof URISyntaxException));
    }
}

