/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionLifecycleException;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;
import org.neo4j.time.SystemNanoClock;

class TransactionFacade {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransactionFacade.class);
    private final String databaseName;
    private final QueryExecutionEngine engine;
    private final TransactionRegistry registry;
    private final TransactionManager transactionManager;
    private final LogProvider logProvider;
    private final BoltGraphDatabaseManagementServiceSPI boltSPI;
    private final AuthManager authManager;
    private final boolean readByDefault;

    TransactionFacade(String databaseName, QueryExecutionEngine engine, TransactionRegistry registry, TransactionManager transactionManager, LogProvider logProvider, BoltGraphDatabaseManagementServiceSPI boltSPI, AuthManager authManager, boolean readByDefault) {
        this.databaseName = databaseName;
        this.engine = engine;
        this.registry = registry;
        this.transactionManager = transactionManager;
        this.logProvider = logProvider;
        this.boltSPI = boltSPI;
        this.authManager = authManager;
        this.readByDefault = readByDefault;
    }

    TransactionHandle newTransactionHandle(TransactionUriScheme uriScheme, boolean implicitTransaction, LoginContext loginContext, ClientConnectionInfo clientConnectionInfo, MemoryTracker memoryTracker, long customTransactionTimeout, SystemNanoClock clock) {
        memoryTracker.allocateHeap(TransactionHandle.SHALLOW_SIZE);
        return new TransactionHandle(this.databaseName, this.engine, this.registry, uriScheme, implicitTransaction, loginContext, clientConnectionInfo, customTransactionTimeout, this.transactionManager, this.logProvider, this.boltSPI, memoryTracker, this.authManager, clock, this.readByDefault);
    }

    TransactionHandle newTransactionHandle(TransactionUriScheme uriScheme, boolean implicitTransaction, LoginContext loginContext, ClientConnectionInfo clientConnectionInfo, MemoryTracker memoryTracker, long customTransactionTimeout, SystemNanoClock clock, boolean isReadOnlyTransaction) {
        memoryTracker.allocateHeap(TransactionHandle.SHALLOW_SIZE);
        return new TransactionHandle(this.databaseName, this.engine, this.registry, uriScheme, implicitTransaction, loginContext, clientConnectionInfo, customTransactionTimeout, this.transactionManager, this.logProvider, this.boltSPI, memoryTracker, this.authManager, clock, isReadOnlyTransaction);
    }

    TransactionHandle findTransactionHandle(long txId) throws TransactionLifecycleException {
        return this.registry.acquire(txId);
    }

    TransactionHandle terminate(long txId) throws TransactionLifecycleException {
        return this.registry.terminate(txId);
    }
}

