/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt.v1;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.server.http.cypher.format.jolt.JoltBasicTypesSerializerTest;
import org.neo4j.server.http.cypher.format.jolt.v1.JoltModuleV1;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={MockitoExtension.class})
class JoltV1SerializerTest {
    private final ObjectMapper objectMapper = new ObjectMapper();

    JoltV1SerializerTest() {
        this.objectMapper.registerModule((Module)JoltModuleV1.STRICT.getInstance());
    }

    void shouldSerializeNode(@Mock Node node) throws JsonProcessingException {
        Mockito.when((Object)node.getId()).thenReturn((Object)4711L);
        Mockito.when((Object)node.getLabels()).thenReturn(List.of(Label.label((String)"A"), Label.label((String)"B")));
        Mockito.when((Object)node.getAllProperties()).thenReturn(new TreeMap<String, String>(Map.of("prop1", 1, "prop2", "Peng")));
        String result = this.objectMapper.writeValueAsString((Object)node);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"()\":[4711,[\"A\",\"B\"],{\"prop1\":{\"Z\":\"1\"},\"prop2\":{\"U\":\"Peng\"}}]}");
    }

    @Test
    void shouldSerializeNodeWithoutLabelsOrProperties(@Mock Node node) throws JsonProcessingException {
        Mockito.when((Object)node.getId()).thenReturn((Object)4711L);
        Mockito.when((Object)node.getLabels()).thenReturn(List.of());
        String result = this.objectMapper.writeValueAsString((Object)node);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"()\":[4711,[],{}]}");
    }

    @Test
    void shouldSerializeRelationship(@Mock Relationship relationship) throws JsonProcessingException {
        Mockito.when((Object)relationship.getId()).thenReturn((Object)4711L);
        Mockito.when((Object)relationship.getType()).thenReturn((Object)RelationshipType.withName((String)"KNOWS"));
        Mockito.when((Object)relationship.getStartNodeId()).thenReturn((Object)123L);
        Mockito.when((Object)relationship.getEndNodeId()).thenReturn((Object)124L);
        Mockito.when((Object)relationship.getAllProperties()).thenReturn(Map.of("since", 1999));
        String result = this.objectMapper.writeValueAsString((Object)relationship);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"->\":[4711,123,\"KNOWS\",124,{\"since\":{\"Z\":\"1999\"}}]}");
    }

    @Test
    void shouldSerializePath(@Mock Path path, @Mock Node start, @Mock Relationship rel, @Mock Node end) throws JsonProcessingException {
        Mockito.when((Object)start.getId()).thenReturn((Object)111L);
        Mockito.when((Object)start.getElementId()).thenReturn((Object)"111");
        Mockito.when((Object)start.getLabels()).thenReturn(List.of());
        Mockito.when((Object)end.getId()).thenReturn((Object)222L);
        Mockito.when((Object)end.getElementId()).thenReturn((Object)"222");
        Mockito.when((Object)end.getLabels()).thenReturn(List.of());
        Mockito.when((Object)rel.getId()).thenReturn((Object)9090L);
        Mockito.when((Object)rel.getType()).thenReturn((Object)RelationshipType.withName((String)"KNOWS"));
        Mockito.when((Object)rel.getStartNodeId()).thenReturn((Object)111L);
        Mockito.when((Object)rel.getStartNode()).thenReturn((Object)start);
        Mockito.when((Object)rel.getEndNodeId()).thenReturn((Object)222L);
        Mockito.when((Object)rel.getAllProperties()).thenReturn(Map.of("since", 1999));
        List<Node> pathList = List.of(start, rel, end);
        Mockito.when((Object)path.iterator()).thenReturn(pathList.iterator());
        String result = this.objectMapper.writeValueAsString((Object)path);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"..\":[{\"()\":[111,[],{}]},{\"->\":[9090,111,\"KNOWS\",222,{\"since\":{\"Z\":\"1999\"}}]},{\"()\":[222,[],{}]}]}");
    }

    @Test
    void shouldSerializeReversedPath(@Mock Path path, @Mock Node start, @Mock Relationship rel, @Mock Node end) throws JsonProcessingException {
        Mockito.when((Object)start.getId()).thenReturn((Object)111L);
        Mockito.when((Object)start.getElementId()).thenReturn((Object)"111");
        Mockito.when((Object)start.getLabels()).thenReturn(List.of());
        Mockito.when((Object)end.getId()).thenReturn((Object)222L);
        Mockito.when((Object)end.getElementId()).thenReturn((Object)"222");
        Mockito.when((Object)end.getLabels()).thenReturn(List.of());
        Mockito.when((Object)rel.getId()).thenReturn((Object)9090L);
        Mockito.when((Object)rel.getType()).thenReturn((Object)RelationshipType.withName((String)"KNOWS"));
        Mockito.when((Object)rel.getStartNodeId()).thenReturn((Object)222L);
        Mockito.when((Object)rel.getStartNode()).thenReturn((Object)end);
        Mockito.when((Object)rel.getEndNodeId()).thenReturn((Object)111L);
        Mockito.when((Object)rel.getEndNode()).thenReturn((Object)start);
        Mockito.when((Object)rel.getAllProperties()).thenReturn(Map.of("since", 1999));
        List<Node> pathList = List.of(start, rel, end);
        Mockito.when((Object)path.iterator()).thenReturn(pathList.iterator());
        String result = this.objectMapper.writeValueAsString((Object)path);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"..\":[{\"()\":[111,[],{}]},{\"<-\":[9090,111,\"KNOWS\",222,{\"since\":{\"Z\":\"1999\"}}]},{\"()\":[222,[],{}]}]}");
    }

    @Test
    void shouldSerializeLongPath(@Mock Path path, @Mock Node start, @Mock Relationship relA, @Mock Node middle, @Mock Relationship relB, @Mock Node end) throws JsonProcessingException {
        Mockito.when((Object)start.getId()).thenReturn((Object)111L);
        Mockito.when((Object)start.getElementId()).thenReturn((Object)"111");
        Mockito.when((Object)start.getLabels()).thenReturn(List.of());
        Mockito.when((Object)middle.getId()).thenReturn((Object)222L);
        Mockito.when((Object)middle.getElementId()).thenReturn((Object)"222");
        Mockito.when((Object)middle.getLabels()).thenReturn(List.of());
        Mockito.when((Object)end.getId()).thenReturn((Object)333L);
        Mockito.when((Object)end.getElementId()).thenReturn((Object)"333");
        Mockito.when((Object)end.getLabels()).thenReturn(List.of());
        Mockito.when((Object)relA.getId()).thenReturn((Object)9090L);
        Mockito.when((Object)relA.getType()).thenReturn((Object)RelationshipType.withName((String)"KNOWS"));
        Mockito.when((Object)relA.getStartNodeId()).thenReturn((Object)111L);
        Mockito.when((Object)relA.getStartNode()).thenReturn((Object)start);
        Mockito.when((Object)relA.getEndNodeId()).thenReturn((Object)222L);
        Mockito.when((Object)relA.getAllProperties()).thenReturn(Map.of("since", 1999));
        Mockito.when((Object)relB.getId()).thenReturn((Object)9090L);
        Mockito.when((Object)relB.getType()).thenReturn((Object)RelationshipType.withName((String)"KNOWS"));
        Mockito.when((Object)relB.getStartNodeId()).thenReturn((Object)333L);
        Mockito.when((Object)relB.getStartNode()).thenReturn((Object)end);
        Mockito.when((Object)relB.getEndNodeId()).thenReturn((Object)222L);
        Mockito.when((Object)relB.getEndNode()).thenReturn((Object)middle);
        Mockito.when((Object)relB.getAllProperties()).thenReturn(Map.of("since", 1990));
        List<Node> pathList = List.of(start, relA, middle, relB, end);
        Mockito.when((Object)path.iterator()).thenReturn(pathList.iterator());
        String result = this.objectMapper.writeValueAsString((Object)path);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"..\":[{\"()\":[111,[],{}]},{\"->\":[9090,111,\"KNOWS\",222,{\"since\":{\"Z\":\"1999\"}}]},{\"()\":[222,[],{}]},{\"<-\":[9090,222,\"KNOWS\",333,{\"since\":{\"Z\":\"1990\"}}]},{\"()\":[333,[],{}]}]}");
    }
}

