/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.server.rest.dbms.AuthorizationEnabledFilter;
import org.neo4j.server.rest.dbms.AuthorizedRequestWrapper;
import org.neo4j.server.security.auth.BasicLoginContext;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.systemgraph.BasicSystemGraphRealm;
import org.neo4j.test.AuthTokenUtil;

class AuthorizationFilterTest {
    private final BasicSystemGraphRealm authManager = (BasicSystemGraphRealm)Mockito.mock(BasicSystemGraphRealm.class);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private final HttpServletRequest servletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    private final HttpServletResponse servletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    private final FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);

    AuthorizationFilterTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        Mockito.when((Object)this.servletResponse.getOutputStream()).thenReturn((Object)new ServletOutputStream(){

            public void write(int b) {
                AuthorizationFilterTest.this.outputStream.write(b);
            }

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
                throw new UnsupportedOperationException();
            }
        });
    }

    @Test
    void shouldAllowOptionsRequests() throws Exception {
        AuthorizationEnabledFilter filter = this.newFilter(new String[0]);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"OPTIONS");
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)ArgumentMatchers.same((Object)this.servletRequest), (ServletResponse)ArgumentMatchers.same((Object)this.servletResponse));
    }

    @Test
    void shouldWhitelistMatchingUris() throws Exception {
        AuthorizationEnabledFilter filter = this.newFilter("/", "/browser.*");
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/", (Object[])new String[]{"/browser/index.html"});
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)ArgumentMatchers.same((Object)this.servletRequest), (ServletResponse)ArgumentMatchers.same((Object)this.servletResponse));
    }

    @Test
    void shouldRequireAuthorizationForNonWhitelistedUris() throws Exception {
        AuthorizationEnabledFilter filter = this.newFilter("/", "/browser.*");
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(401);
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("WWW-Authenticate", "Basic realm=\"Neo4j\"");
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("Content-Type", "application/json; charset=UTF-8");
        LogAssertions.assertThat((String)this.outputStream.toString(StandardCharsets.UTF_8.name())).contains(new CharSequence[]{"\"code\" : \"Neo.ClientError.Security.Unauthorized\""});
        LogAssertions.assertThat((String)this.outputStream.toString(StandardCharsets.UTF_8.name())).contains(new CharSequence[]{"\"message\" : \"No authentication header supplied.\""});
    }

    @Test
    void shouldRequireValidAuthorizationHeader() throws Exception {
        AuthorizationEnabledFilter filter = this.newFilter(new String[0]);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)"NOT A VALID VALUE");
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(400);
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("Content-Type", "application/json; charset=UTF-8");
        LogAssertions.assertThat((String)this.outputStream.toString(StandardCharsets.UTF_8.name())).contains(new CharSequence[]{"\"code\" : \"Neo.ClientError.Request.InvalidFormat\""});
        LogAssertions.assertThat((String)this.outputStream.toString(StandardCharsets.UTF_8.name())).contains(new CharSequence[]{"\"message\" : \"Invalid authentication header.\""});
    }

    @Test
    void shouldNotAuthorizeInvalidCredentials() throws Exception {
        AuthorizationEnabledFilter filter = this.newFilter(new String[0]);
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(StandardCharsets.UTF_8));
        BasicLoginContext loginContext = (BasicLoginContext)Mockito.mock(BasicLoginContext.class);
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)this.servletRequest.getRemoteAddr()).thenReturn((Object)"client");
        Mockito.when((Object)this.servletRequest.getRemotePort()).thenReturn((Object)1337);
        Mockito.when((Object)this.servletRequest.getServerName()).thenReturn((Object)"server");
        Mockito.when((Object)this.servletRequest.getServerPort()).thenReturn((Object)42);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.servletRequest.getRemoteAddr()).thenReturn((Object)"remote_ip_address");
        Mockito.when((Object)this.authManager.login((Map)ArgumentMatchers.argThat((ArgumentMatcher)new AuthTokenMatcher(SecurityTestUtils.authToken((String)"foo", (String)"bar"))), (ClientConnectionInfo)ArgumentMatchers.any())).thenReturn((Object)loginContext);
        Mockito.when((Object)loginContext.subject()).thenReturn((Object)authSubject);
        Mockito.when((Object)authSubject.getAuthenticationResult()).thenReturn((Object)AuthenticationResult.FAILURE);
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(AuthorizationEnabledFilter.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"Failed authentication attempt for '%s' from %s", "foo", "remote_ip_address"});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(401);
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("Content-Type", "application/json; charset=UTF-8");
        LogAssertions.assertThat((String)this.outputStream.toString(StandardCharsets.UTF_8.name())).contains(new CharSequence[]{"\"code\" : \"Neo.ClientError.Security.Unauthorized\""});
        LogAssertions.assertThat((String)this.outputStream.toString(StandardCharsets.UTF_8.name())).contains(new CharSequence[]{"\"message\" : \"Invalid username or password.\""});
    }

    @Test
    void shouldAuthorizeWhenPasswordChangeRequired() throws Exception {
        AuthorizationEnabledFilter filter = this.newFilter(new String[0]);
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(StandardCharsets.UTF_8));
        BasicLoginContext loginContext = (BasicLoginContext)Mockito.mock(BasicLoginContext.class);
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)this.servletRequest.getRemoteAddr()).thenReturn((Object)"client");
        Mockito.when((Object)this.servletRequest.getRemotePort()).thenReturn((Object)1337);
        Mockito.when((Object)this.servletRequest.getServerName()).thenReturn((Object)"server");
        Mockito.when((Object)this.servletRequest.getServerPort()).thenReturn((Object)42);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getRequestURL()).thenReturn((Object)new StringBuffer("http://bar.baz:7474/db/data/"));
        Mockito.when((Object)this.servletRequest.getRequestURI()).thenReturn((Object)"/db/data/");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.authManager.login((Map)ArgumentMatchers.argThat((ArgumentMatcher)new AuthTokenMatcher(SecurityTestUtils.authToken((String)"foo", (String)"bar"))), (ClientConnectionInfo)ArgumentMatchers.any())).thenReturn((Object)loginContext);
        Mockito.when((Object)loginContext.subject()).thenReturn((Object)authSubject);
        Mockito.when((Object)authSubject.getAuthenticationResult()).thenReturn((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)ArgumentMatchers.eq((Object)new AuthorizedRequestWrapper("BASIC", "foo", this.servletRequest, LoginContext.AUTH_DISABLED)), (ServletResponse)ArgumentMatchers.same((Object)this.servletResponse));
    }

    @Test
    void shouldNotAuthorizeWhenTooManyAttemptsMade() throws Exception {
        AuthorizationEnabledFilter filter = this.newFilter(new String[0]);
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(StandardCharsets.UTF_8));
        BasicLoginContext loginContext = (BasicLoginContext)Mockito.mock(BasicLoginContext.class);
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)this.servletRequest.getRemoteAddr()).thenReturn((Object)"client");
        Mockito.when((Object)this.servletRequest.getRemotePort()).thenReturn((Object)1337);
        Mockito.when((Object)this.servletRequest.getServerName()).thenReturn((Object)"server");
        Mockito.when((Object)this.servletRequest.getServerPort()).thenReturn((Object)42);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.authManager.login((Map)ArgumentMatchers.argThat((ArgumentMatcher)new AuthTokenMatcher(SecurityTestUtils.authToken((String)"foo", (String)"bar"))), (ClientConnectionInfo)ArgumentMatchers.any())).thenReturn((Object)loginContext);
        Mockito.when((Object)loginContext.subject()).thenReturn((Object)authSubject);
        Mockito.when((Object)authSubject.getAuthenticationResult()).thenReturn((Object)AuthenticationResult.TOO_MANY_ATTEMPTS);
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(429);
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("Content-Type", "application/json; charset=UTF-8");
        LogAssertions.assertThat((String)this.outputStream.toString(StandardCharsets.UTF_8.name())).contains(new CharSequence[]{"\"code\" : \"Neo.ClientError.Security.AuthenticationRateLimit\""});
        LogAssertions.assertThat((String)this.outputStream.toString(StandardCharsets.UTF_8.name())).contains(new CharSequence[]{"\"message\" : \"Too many failed authentication requests. Please wait 5 seconds and try again.\""});
    }

    @Test
    void shouldAuthorizeWhenValidCredentialsSupplied() throws Exception {
        AuthorizationEnabledFilter filter = this.newFilter(new String[0]);
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(StandardCharsets.UTF_8));
        BasicLoginContext loginContext = (BasicLoginContext)Mockito.mock(BasicLoginContext.class);
        AuthSubject authSubject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)this.servletRequest.getRemoteAddr()).thenReturn((Object)"client");
        Mockito.when((Object)this.servletRequest.getRemotePort()).thenReturn((Object)1337);
        Mockito.when((Object)this.servletRequest.getServerName()).thenReturn((Object)"server");
        Mockito.when((Object)this.servletRequest.getServerPort()).thenReturn((Object)42);
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.authManager.login((Map)ArgumentMatchers.argThat((ArgumentMatcher)new AuthTokenMatcher(SecurityTestUtils.authToken((String)"foo", (String)"bar"))), (ClientConnectionInfo)ArgumentMatchers.any())).thenReturn((Object)loginContext);
        Mockito.when((Object)loginContext.subject()).thenReturn((Object)authSubject);
        Mockito.when((Object)authSubject.getAuthenticationResult()).thenReturn((Object)AuthenticationResult.SUCCESS);
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)ArgumentMatchers.eq((Object)new AuthorizedRequestWrapper("BASIC", "foo", this.servletRequest, LoginContext.AUTH_DISABLED)), (ServletResponse)ArgumentMatchers.same((Object)this.servletResponse));
    }

    @Test
    void shouldIncludeCrippledAuthHeaderIfBrowserIsTheOneCalling() throws Throwable {
        AuthorizationEnabledFilter filter = this.newFilter("/", "/browser.*");
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("X-Ajax-Browser-Auth")).thenReturn((Object)"true");
        filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(401);
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("WWW-Authenticate", "None");
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).addHeader("Content-Type", "application/json; charset=UTF-8");
        LogAssertions.assertThat((String)this.outputStream.toString(StandardCharsets.UTF_8.name())).contains(new CharSequence[]{"\"code\" : \"Neo.ClientError.Security.Unauthorized\""});
        LogAssertions.assertThat((String)this.outputStream.toString(StandardCharsets.UTF_8.name())).contains(new CharSequence[]{"\"message\" : \"No authentication header supplied.\""});
    }

    private AuthorizationEnabledFilter newFilter(String ... uriWhitelist) {
        List uriWhitelistPatterns = Arrays.stream(uriWhitelist).map(Pattern::compile).collect(Collectors.toList());
        return new AuthorizationEnabledFilter(() -> this.authManager, (InternalLogProvider)this.logProvider, uriWhitelistPatterns);
    }

    private static class AuthTokenMatcher
    implements ArgumentMatcher<Map<String, Object>> {
        private final Map<String, Object> expectedMap;

        AuthTokenMatcher(Map<String, Object> expectedMap) {
            this.expectedMap = expectedMap;
        }

        public boolean matches(Map<String, Object> map) {
            return AuthTokenUtil.matches(this.expectedMap, map);
        }
    }
}

