/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.response;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyWriter;
import org.neo4j.driver.Session;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.logging.InternalLog;
import org.neo4j.server.http.cypher.format.api.ConnectionException;
import org.neo4j.server.queryapi.request.ResultContainer;
import org.neo4j.server.queryapi.response.DriverResultSerializer;

abstract class AbstractDriverResultWriter
implements MessageBodyWriter<ResultContainer> {
    private final InternalLog log;

    public AbstractDriverResultWriter(InternalLog log) {
        this.log = log;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ResultContainer.class.isAssignableFrom(type);
    }

    public void writeDriverResult(JsonFactory factory, ResultContainer result, OutputStream outputStream) throws IOException {
        JsonGenerator jsonGenerator = factory.createGenerator(outputStream);
        DriverResultSerializer resultSerializer = new DriverResultSerializer(jsonGenerator);
        try (Session session = result.session();){
            resultSerializer.writeFieldNames(result.result().keys());
            while (result.result().hasNext()) {
                resultSerializer.writeValue(result.result().next());
            }
            resultSerializer.finish(result.result().consume(), session.lastBookmarks(), result.queryRequest());
        }
        catch (Neo4jException ex) {
            try {
                resultSerializer.writeError(ex);
            }
            catch (IOException errorWritingException) {
                this.log.warn("An error was thrown whilst attempting to write an error.", (Throwable)errorWritingException);
            }
        }
        catch (IOException ex) {
            throw new ConnectionException("Failed to write to the connection", ex);
        }
        finally {
            jsonGenerator.flush();
        }
    }
}

