/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.driver;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import java.net.URI;
import java.time.Clock;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logging;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.internal.BoltAgent;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.GqlNotificationConfig;
import org.neo4j.driver.internal.async.connection.ChannelConnector;
import org.neo4j.driver.internal.async.connection.EventLoopGroupFactory;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.security.StaticAuthTokenManager;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.server.queryapi.driver.DriverToInternalLogProvider;
import org.neo4j.server.queryapi.driver.LocalChannelConnector;

public final class LocalChannelDriverFactory
extends DriverFactory {
    public static final URI IGNORED_HTTP_DRIVER_URI = URI.create("bolt://http-driver.com:0");
    private final LocalAddress localAddress;
    private final InternalLogProvider internalLogProvider;

    public LocalChannelDriverFactory(LocalAddress localAddress, InternalLogProvider internalLogProvider) {
        this.localAddress = localAddress;
        this.internalLogProvider = internalLogProvider;
    }

    protected Bootstrap createBootstrap(int threadCount) {
        return LocalChannelDriverFactory.newBootstrap(threadCount);
    }

    protected ChannelConnector createConnector(ConnectionSettings settings, SecurityPlan securityPlan, Config config, Clock clock, RoutingContext routingContext, BoltAgent boltAgent) {
        return new LocalChannelConnector(this.localAddress, config.userAgent(), boltAgent, settings.authTokenProvider(), GqlNotificationConfig.from((NotificationConfig)config.notificationConfig()), securityPlan, clock, config.logging());
    }

    public Driver createLocalDriver() {
        return super.newInstance(IGNORED_HTTP_DRIVER_URI, (AuthTokenManager)new StaticAuthTokenManager(AuthTokens.none()), null, Config.builder().withLogging((Logging)new DriverToInternalLogProvider(this.internalLogProvider)).withUserAgent("neo4j-query-api/v2").build());
    }

    public static Bootstrap newBootstrap(int threadCount) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(EventLoopGroupFactory.newEventLoopGroup((int)threadCount));
        bootstrap.channel(LocalChannel.class);
        return bootstrap;
    }
}

