/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.server.configuration.ConfigurableTransports;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.web.JettyHttp2ConnectionListener;
import org.neo4j.server.web.JettyHttpConnectionFactory;
import org.neo4j.server.web.JettyThreadCalculator;

public class HttpConnectorFactory {
    private static final String HTTP_NAME = "http";
    private static final String HTTP2_NAME = "http2";
    private final String name;
    protected final NetworkConnectionTracker connectionTracker;
    protected final Config configuration;
    private final ByteBufferPool byteBufferPool;

    public HttpConnectorFactory(NetworkConnectionTracker connectionTracker, Config config, ByteBufferPool byteBufferPool) {
        this(HTTP_NAME, connectionTracker, config, byteBufferPool);
    }

    protected HttpConnectorFactory(String name, NetworkConnectionTracker connectionTracker, Config configuration, ByteBufferPool byteBufferPool) {
        this.name = name;
        this.connectionTracker = connectionTracker;
        this.configuration = configuration;
        this.byteBufferPool = byteBufferPool;
    }

    public List<ConnectionFactory> createHttpConnectionFactories(boolean requiresHostnameVerification) {
        HttpConfiguration httpConfig = this.createHttpConfig(requiresHostnameVerification);
        ArrayList<ConnectionFactory> connectionFactories = new ArrayList<ConnectionFactory>();
        if (((Set)this.configuration.get(ServerSettings.http_enabled_transports)).contains((Object)ConfigurableTransports.HTTP1_1)) {
            connectionFactories.add((ConnectionFactory)new JettyHttpConnectionFactory(this.connectionTracker, httpConfig));
        }
        if (((Set)this.configuration.get(ServerSettings.http_enabled_transports)).contains((Object)ConfigurableTransports.HTTP2)) {
            JettyHttp2ConnectionListener http2ConnectionListener = new JettyHttp2ConnectionListener(this.connectionTracker, HTTP2_NAME);
            HTTP2CServerConnectionFactory h2c = new HTTP2CServerConnectionFactory(httpConfig);
            h2c.addBean((Object)http2ConnectionListener);
            HTTP2ServerConnectionFactory directHttp2 = new HTTP2ServerConnectionFactory(httpConfig);
            directHttp2.addBean((Object)http2ConnectionListener);
            connectionFactories.add((ConnectionFactory)h2c);
            connectionFactories.add((ConnectionFactory)directHttp2);
        }
        return connectionFactories;
    }

    protected HttpConfiguration createHttpConfig(boolean ignored) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setRequestHeaderSize(((Integer)this.configuration.get(ServerSettings.maximum_request_header_size)).intValue());
        httpConfig.setResponseHeaderSize(((Integer)this.configuration.get(ServerSettings.maximum_response_header_size)).intValue());
        httpConfig.setSendServerVersion(false);
        return httpConfig;
    }

    public ServerConnector createConnector(Server server, SocketAddress address, JettyThreadCalculator jettyThreadCalculator) {
        List<ConnectionFactory> httpFactories = this.createHttpConnectionFactories(false);
        return this.createConnector(server, address, jettyThreadCalculator, httpFactories);
    }

    public ServerConnector createConnector(Server server, SocketAddress address, JettyThreadCalculator jettyThreadCalculator, List<ConnectionFactory> httpFactories) {
        int acceptors = jettyThreadCalculator.getAcceptors();
        int selectors = jettyThreadCalculator.getSelectors();
        ServerConnector connector = new ServerConnector(server, null, null, this.byteBufferPool, acceptors, selectors, httpFactories.toArray(new ConnectionFactory[0]));
        connector.setName(this.name);
        connector.setConnectionFactories(httpFactories);
        connector.setAcceptQueueSize(50);
        connector.setHost(address.getHostname());
        connector.setPort(address.getPort());
        return connector;
    }
}

