/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.response;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.ResultSummary;

public class DriverResultSerializer {
    private final JsonGenerator jsonGenerator;
    private State currentState = State.ROOT;

    public DriverResultSerializer(JsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
    }

    public void writeRecords(Result result) throws IOException {
        this.jsonGenerator.writeStartObject();
        if (result != null) {
            this.writeFieldNames(result.keys());
            while (result.hasNext()) {
                this.writeValue(result.next());
            }
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.writeEndObject();
        }
    }

    public void writeFieldNames(List<String> keys) throws IOException {
        this.jsonGenerator.writeFieldName("data");
        this.jsonGenerator.writeStartObject();
        this.jsonGenerator.writeArrayFieldStart("fields");
        for (String key : keys) {
            this.jsonGenerator.writeString(key);
        }
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.writeArrayFieldStart("values");
        this.currentState = State.IN_VALUES;
    }

    public void writeValue(Record record) throws IOException {
        this.jsonGenerator.writeStartArray();
        this.jsonGenerator.writeObject((Object)record);
        this.jsonGenerator.writeEndArray();
    }

    public void writeError(Neo4jException neo4jException) throws IOException {
        this.ensureResultSetClosedForErrorsWriting();
        this.jsonGenerator.writeFieldName("errors");
        this.jsonGenerator.writeStartArray();
        this.jsonGenerator.writeObject((Object)neo4jException);
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.writeEndObject();
    }

    public void writeNotifications(List<Notification> notifications) throws IOException {
        if (!notifications.isEmpty()) {
            this.jsonGenerator.writeFieldName("notifications");
            this.jsonGenerator.writeObject(notifications);
        }
    }

    public void writeTxInfo(String txId, Instant timeout) throws IOException {
        if (txId != null && timeout != null) {
            this.jsonGenerator.writeObjectFieldStart("transaction");
            this.jsonGenerator.writeStringField("id", txId);
            this.jsonGenerator.writeStringField("expires", timeout.toString());
            this.jsonGenerator.writeEndObject();
        }
    }

    public void finish(ResultSummary resultSummary, Set<Bookmark> bookmarks, boolean requireCounters) throws IOException {
        this.finish(resultSummary, bookmarks, null, null, requireCounters);
    }

    public void finish(ResultSummary resultSummary, Set<Bookmark> bookmarks, String txId, Instant timeout, boolean requireCounters) throws IOException {
        this.writeNotifications(resultSummary.notifications());
        if (requireCounters) {
            this.writeCounters(resultSummary);
        }
        this.writeProfile(resultSummary);
        this.writeQueryPlan(resultSummary);
        this.writeBookmarks(bookmarks);
        this.writeTxInfo(txId, timeout);
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.flush();
    }

    private void writeCounters(ResultSummary resultSummary) throws IOException {
        this.jsonGenerator.writeFieldName("counters");
        this.jsonGenerator.writeObject((Object)resultSummary.counters());
    }

    private void writeProfile(ResultSummary resultSummary) throws IOException {
        if (resultSummary.hasPlan() && resultSummary.hasProfile()) {
            this.jsonGenerator.writeFieldName("profiledQueryPlan");
            this.jsonGenerator.writeObject((Object)resultSummary.profile());
        }
    }

    private void writeQueryPlan(ResultSummary resultSummary) throws IOException {
        if (resultSummary.hasPlan() && !resultSummary.hasProfile()) {
            this.jsonGenerator.writeFieldName("queryPlan");
            this.jsonGenerator.writeObject((Object)resultSummary.plan());
        }
    }

    private void writeBookmarks(Set<Bookmark> bookmarks) throws IOException {
        if (bookmarks != null) {
            this.jsonGenerator.writeArrayFieldStart("bookmarks");
            for (Bookmark bookmark : bookmarks) {
                this.jsonGenerator.writeString(bookmark.value());
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    private void ensureResultSetClosedForErrorsWriting() throws IOException {
        if (this.currentState == State.IN_VALUES) {
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.writeEndObject();
        }
    }

    private static enum State {
        ROOT,
        IN_VALUES;

    }
}

