/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.message.result.BoltResult;
import org.neo4j.bolt.protocol.common.message.result.ResultConsumer;
import org.neo4j.bolt.protocol.common.transaction.statement.metadata.StatementMetadata;
import org.neo4j.bolt.transaction.CleanUpConnectionContext;
import org.neo4j.bolt.transaction.InitializeContext;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.bolt.transaction.TransactionNotFoundException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.http.cypher.Invocation;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.RollbackInvocation;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.http.cypher.format.api.ConnectionException;
import org.neo4j.server.http.cypher.format.api.InputEventStream;
import org.neo4j.server.http.cypher.format.api.InputFormatException;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.server.http.cypher.format.api.TransactionNotificationState;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;
import org.neo4j.time.Clocks;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

class InvocationTest {
    private static final Statement NULL_STATEMENT = null;
    private static final String TX_ID = "123";
    private final InternalLog log = (InternalLog)Mockito.mock(InternalLog.class);
    private final QueryExecutionType queryExecutionType = null;
    private final org.neo4j.cypher.internal.runtime.QueryStatistics queryStatistics = (org.neo4j.cypher.internal.runtime.QueryStatistics)Mockito.mock(org.neo4j.cypher.internal.runtime.QueryStatistics.class);
    private final ExecutionPlanDescription executionPlanDescription = (ExecutionPlanDescription)Mockito.mock(ExecutionPlanDescription.class);
    private final Iterable<Notification> notifications = Collections.emptyList();
    private final TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
    private final InternalLogProvider logProvider = (InternalLogProvider)Mockito.mock(InternalLogProvider.class);
    private final BoltGraphDatabaseManagementServiceSPI boltSPI = (BoltGraphDatabaseManagementServiceSPI)Mockito.mock(BoltGraphDatabaseManagementServiceSPI.class);
    private final QueryExecutionEngine executionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
    private final InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
    private final TransactionRegistry registry = (TransactionRegistry)Mockito.mock(TransactionRegistry.class);
    private final OutputEventStream outputEventStream = (OutputEventStream)Mockito.mock(OutputEventStream.class);
    private final MemoryTracker memoryTracker = (MemoryTracker)Mockito.mock(MemoryTracker.class);
    private final AuthManager authManager = (AuthManager)Mockito.mock(AuthManager.class);
    private final StatementMetadata metadata = (StatementMetadata)Mockito.mock(StatementMetadata.class);
    private final BoltResult boltResult = (BoltResult)Mockito.mock(BoltResult.class);
    private final String[] DEFAULT_FIELD_NAMES = new String[]{"c1", "c2", "c3"};
    private static final TransactionUriScheme uriScheme = new TransactionUriScheme(){

        public URI txUri(long id) {
            return URI.create("transaction/" + id);
        }

        public URI txCommitUri(long id) {
            return URI.create("transaction/" + id + "/commit");
        }

        public URI dbUri() {
            return URI.create("data/");
        }
    };

    InvocationTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        Mockito.when((Object)this.metadata.fieldNames()).thenReturn((Object)this.DEFAULT_FIELD_NAMES);
        Mockito.when((Object)this.transactionManager.begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString())).thenReturn((Object)TX_ID);
        Mockito.when((Object)this.transactionManager.runQuery(TX_ID, "query", MapValue.EMPTY)).thenReturn((Object)this.metadata);
        ((TransactionManager)Mockito.doAnswer(invocationOnMock -> {
            ResultConsumer resultConsumer = (ResultConsumer)invocationOnMock.getArgument(3, ResultConsumer.class);
            resultConsumer.consume(this.boltResult);
            return Bookmark.EMPTY_BOOKMARK;
        }).when((Object)this.transactionManager)).pullData((String)Mockito.any(String.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Long)Mockito.any(Long.class)).longValue(), (ResultConsumer)Mockito.any(ResultConsumer.class));
    }

    @Test
    void shouldExecuteStatements() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(Long.parseLong(TX_ID)), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any(InitializeContext.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)true), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString());
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, "query", MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).pullData((String)Mockito.any(String.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Long)Mockito.any(Long.class)).longValue(), (ResultConsumer)Mockito.any(ResultConsumer.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).commit(TX_ID);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(123L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldSuspendTransactionAndReleaseForOtherRequestsAfterExecutingStatements() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, false);
        invocation.execute(this.outputEventStream);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.registry});
        ((TransactionRegistry)transactionOrder.verify((Object)this.registry)).release(123L, handle);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any(InitializeContext.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)true), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString());
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, "query", MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).pullData((String)Mockito.any(String.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Long)Mockito.any(Long.class)).longValue(), (ResultConsumer)Mockito.any(ResultConsumer.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.OPEN, uriScheme.txCommitUri(123L), 0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldResumeTransactionWhenExecutingStatementsOnSecondRequest() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, false);
        invocation.execute(this.outputEventStream);
        Mockito.reset((Object[])new Object[]{this.registry, this.outputEventStream});
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        invocation.execute(this.outputEventStream);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.registry, this.transactionManager});
        ((TransactionRegistry)order.verify((Object)this.registry)).release(123L, handle);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any(InitializeContext.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)true), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString());
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, "query", MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).pullData((String)Mockito.any(String.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Long)Mockito.any(Long.class)).longValue(), (ResultConsumer)Mockito.any(ResultConsumer.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, "query", MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).pullData((String)Mockito.any(String.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Long)Mockito.any(Long.class)).longValue(), (ResultConsumer)Mockito.any(ResultConsumer.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.OPEN, uriScheme.txCommitUri(123L), 0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldCommitTransactionAndTellRegistryToForgetItsHandle() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.internalTransaction, this.registry});
        ((TransactionRegistry)transactionOrder.verify((Object)this.registry)).forget(123L);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any(InitializeContext.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, "query", MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).commit(TX_ID);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        txManagerOrder.verifyNoMoreInteractions();
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(123L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldRollbackTransactionAndTellRegistryToForgetItsHandle() throws Exception {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        RollbackInvocation invocation = new RollbackInvocation(this.log, handle);
        invocation.execute(this.outputEventStream);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager, this.registry});
        ((TransactionManager)transactionOrder.verify((Object)this.transactionManager)).rollback(TX_ID);
        ((TransactionRegistry)transactionOrder.verify((Object)this.registry)).forget(123L);
        ((TransactionManager)transactionOrder.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, null, -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldCreateTransactionContextOnlyWhenFirstNeeded() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        InOrder transactionOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)transactionOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any());
        transactionOrder.verifyNoMoreInteractions();
        invocation.execute(this.outputEventStream);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any(InitializeContext.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)true), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString());
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, "query", MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).pullData((String)Mockito.any(String.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Long)Mockito.any(Long.class)).longValue(), (ResultConsumer)Mockito.any(ResultConsumer.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).commit(TX_ID);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(123L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldRollbackTransactionIfExecutionErrorOccurs() throws Exception {
        Mockito.when((Object)this.transactionManager.runQuery(TX_ID, "query", MapValue.EMPTY)).thenThrow(new Throwable[]{(Throwable)Mockito.mock(TransactionNotFoundException.class)});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any(InitializeContext.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)true), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString());
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, "query", MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).rollback(TX_ID);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.ExecutionFailed, null);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(123L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleCommitError() throws Throwable {
        KernelException commitError = (KernelException)Mockito.mock(KernelException.class);
        Mockito.when((Object)commitError.getMessage()).thenReturn((Object)"Something went wrong!");
        Mockito.when((Object)this.transactionManager.commit(TX_ID)).thenThrow(new Throwable[]{commitError});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalLog)Mockito.verify((Object)this.log)).error((String)Mockito.eq((Object)"Failed to commit transaction."), (Throwable)Mockito.any(KernelException.class));
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any(InitializeContext.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)true), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString());
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, "query", MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).pullData((String)Mockito.any(String.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Long)Mockito.any(Long.class)).longValue(), (ResultConsumer)Mockito.any(ResultConsumer.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).commit(TX_ID);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Mockito.any(), (String)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.UNKNOWN, uriScheme.txCommitUri(123L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleErrorWhenStartingTransaction() throws Throwable {
        Mockito.when((Object)this.transactionManager.begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)true), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString())).thenThrow(new Throwable[]{(Throwable)Mockito.mock(KernelException.class)});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalLog)Mockito.verify((Object)this.log)).error((String)Mockito.eq((Object)"Failed to start transaction"), (Throwable)Mockito.any(KernelException.class));
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Mockito.any(), (String)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.NO_TRANSACTION, uriScheme.txCommitUri(123L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleAuthorizationErrorWhenStartingTransaction() throws Throwable {
        Mockito.when((Object)this.transactionManager.begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)true), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new AuthorizationViolationException("Forbidden")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.log});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Security.Forbidden, "Forbidden");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.NO_TRANSACTION, uriScheme.txCommitUri(1337L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleCypherSyntaxError() throws Exception {
        String queryText = "matsch (n) return n";
        Mockito.when((Object)this.transactionManager.runQuery(TX_ID, queryText, MapValue.EMPTY)).thenThrow(new Throwable[]{new RuntimeException((Throwable)new SyntaxException("did you mean MATCH?"))});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement(queryText, MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any(InitializeContext.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)true), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString());
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, queryText, MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).rollback(TX_ID);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.SyntaxError, "did you mean MATCH?");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(123L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleExecutionEngineThrowingUndeclaredCheckedExceptions() throws Exception {
        Mockito.when((Object)this.transactionManager.runQuery(TX_ID, "query", MapValue.EMPTY)).thenThrow(new Throwable[]{new RuntimeException("BOO")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any(InitializeContext.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)true), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString());
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, "query", MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).rollback(TX_ID);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.ExecutionFailed, "BOO");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(123L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleRollbackError() throws Exception {
        Mockito.when((Object)this.transactionManager.runQuery(TX_ID, "query", MapValue.EMPTY)).thenThrow(new Throwable[]{new RuntimeException("BOO")});
        ((TransactionManager)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("Something went wrong")}).when((Object)this.transactionManager)).rollback(TX_ID);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((InternalLog)Mockito.verify((Object)this.log)).error((String)Mockito.eq((Object)"Failed to roll back transaction."), (Throwable)Mockito.any(IllegalStateException.class));
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any(InitializeContext.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)true), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString());
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, "query", MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).rollback(TX_ID);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Statement.ExecutionFailed, "BOO");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Transaction.TransactionRollbackFailed, "Something went wrong");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.UNKNOWN, uriScheme.txCommitUri(123L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldInterruptTransaction() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        handle.terminate();
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).interrupt(TX_ID);
    }

    @Test
    void deadlockExceptionHasCorrectStatus() throws Throwable {
        Mockito.when((Object)this.transactionManager.runQuery(TX_ID, "query", MapValue.EMPTY)).thenThrow(new Throwable[]{new DeadlockDetectedException("deadlock")});
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any(InitializeContext.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)true), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString());
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, "query", MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).rollback(TX_ID);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Transaction.DeadlockDetected, "deadlock");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(123L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void startTransactionWithRequestedTimeout() throws Exception {
        TransactionManager txManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        TransactionHandle handle = new TransactionHandle("neo4j", this.executionEngine, (TransactionRegistry)Mockito.mock(TransactionRegistry.class), uriScheme, true, LoginContext.AUTH_DISABLED, (ClientConnectionInfo)Mockito.mock(ClientConnectionInfo.class), 100L, txManager, (InternalLogProvider)Mockito.mock(InternalLogProvider.class), (BoltGraphDatabaseManagementServiceSPI)Mockito.mock(BoltGraphDatabaseManagementServiceSPI.class), (MemoryTracker)Mockito.mock(MemoryTracker.class), (AuthManager)Mockito.mock(AuthManager.class), Clocks.nanoClock(), true);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenReturn(null);
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransactionManager)Mockito.verify((Object)txManager)).initialize((InitializeContext)Mockito.any());
        ((TransactionManager)Mockito.verify((Object)txManager)).begin(LoginContext.AUTH_DISABLED, "neo4j", Collections.emptyList(), true, Collections.emptyMap(), Duration.ofMillis(100L), null, "0");
    }

    @Test
    void shouldHandleInputParsingErrorWhenReadingStatements() throws Exception {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenThrow(new Throwable[]{new InputFormatException("Cannot parse input", (Throwable)new IOException("JSON ERROR"))});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).rollback(TX_ID);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeFailure((Status)Status.Request.InvalidFormat, "Cannot parse input");
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.ROLLED_BACK, uriScheme.txCommitUri(123L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleConnectionErrorWhenReadingStatementsInImplicitTransaction() throws Exception {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenThrow(new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(123L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        ConnectionException e = (ConnectionException)Assertions.assertThrows(ConnectionException.class, () -> invocation.execute(this.outputEventStream));
        Assertions.assertEquals((Object)"Connection error", (Object)e.getMessage());
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).rollback(TX_ID);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(123L);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldKeepTransactionOpenIfConnectionErrorWhenReadingStatementsInExplicitTransaction() throws Exception {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry, false, true);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)inputEventStream.read()).thenThrow(new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))});
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        ConnectionException e = (ConnectionException)Assertions.assertThrows(ConnectionException.class, () -> invocation.execute(this.outputEventStream));
        Assertions.assertEquals((Object)"Connection error", (Object)e.getMessage());
        ((TransactionManager)Mockito.verify((Object)this.transactionManager, (VerificationMode)Mockito.never())).rollback(TX_ID);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager, (VerificationMode)Mockito.never())).commit(TX_ID);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager, (VerificationMode)Mockito.never())).cleanUp((CleanUpConnectionContext)Mockito.any(CleanUpConnectionContext.class));
        ((TransactionRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.never())).forget(1337L);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldHandleConnectionErrorWhenWritingOutputInImplicitTransaction() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        ((OutputEventStream)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))}).when((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ConnectionException e = (ConnectionException)Assertions.assertThrows(ConnectionException.class, () -> invocation.execute(this.outputEventStream));
        Assertions.assertEquals((Object)"Connection error", (Object)e.getMessage());
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).rollback(TX_ID);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext("1337")));
        ((TransactionRegistry)Mockito.verify((Object)this.registry)).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldKeepTransactionOpenIfConnectionErrorWhenWritingOutputInImplicitTransaction() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry, false, true);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(1337L), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, false);
        ((OutputEventStream)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectionException("Connection error", (Throwable)new IOException("Broken pipe"))}).when((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ConnectionException e = (ConnectionException)Assertions.assertThrows(ConnectionException.class, () -> invocation.execute(this.outputEventStream));
        Assertions.assertEquals((Object)"Connection error", (Object)e.getMessage());
        ((TransactionManager)Mockito.verify((Object)this.transactionManager, (VerificationMode)Mockito.never())).rollback(TX_ID);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager, (VerificationMode)Mockito.never())).cleanUp((CleanUpConnectionContext)Mockito.any(CleanUpConnectionContext.class));
        ((TransactionRegistry)Mockito.verify((Object)this.registry, (VerificationMode)Mockito.never())).forget(1337L);
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    @Test
    void shouldAllocateAndFreeMemory() throws Throwable {
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry, false, true);
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)new Statement("query", MapUtil.map((Object[])new Object[0])), (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        Invocation invocation = new Invocation((InternalLog)Mockito.mock(InternalLog.class), handle, uriScheme.txCommitUri(1337L), memoryPool, inputEventStream, true);
        invocation.execute(this.outputEventStream);
        ((MemoryPool)Mockito.verify((Object)memoryPool, (VerificationMode)Mockito.times((int)2))).reserveHeap(Statement.SHALLOW_SIZE);
        ((MemoryPool)Mockito.verify((Object)memoryPool, (VerificationMode)Mockito.times((int)2))).releaseHeap(Statement.SHALLOW_SIZE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{memoryPool});
    }

    @Test
    void shouldFreeMemoryOnException() throws Throwable {
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry, false, true);
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)1337L);
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)new Statement("query", MapUtil.map((Object[])new Object[0])), (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        ((OutputEventStream)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectionException("Something broke", (Throwable)new IOException("Oh no"))}).when((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        Invocation invocation = new Invocation((InternalLog)Mockito.mock(InternalLog.class), handle, uriScheme.txCommitUri(1337L), memoryPool, inputEventStream, true);
        Assertions.assertThrows(ConnectionException.class, () -> invocation.execute(this.outputEventStream));
        ((MemoryPool)Mockito.verify((Object)memoryPool)).reserveHeap(Statement.SHALLOW_SIZE);
        ((MemoryPool)Mockito.verify((Object)memoryPool)).releaseHeap(Statement.SHALLOW_SIZE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{memoryPool});
    }

    @Test
    void shouldExecuteStatementsWithWriteTransaction() throws Throwable {
        Mockito.when((Object)this.registry.begin((TransactionHandle)Mockito.any(TransactionHandle.class))).thenReturn((Object)123L);
        TransactionHandle handle = this.getTransactionHandle(this.executionEngine, this.registry, true, false);
        InputEventStream inputEventStream = (InputEventStream)Mockito.mock(InputEventStream.class);
        Statement statement = new Statement("query", MapUtil.map((Object[])new Object[0]));
        Mockito.when((Object)inputEventStream.read()).thenReturn((Object)statement, (Object[])new Statement[]{NULL_STATEMENT});
        this.setupResultMocks();
        Invocation invocation = new Invocation(this.log, handle, uriScheme.txCommitUri(Long.parseLong(TX_ID)), (MemoryPool)Mockito.mock(MemoryPool.class, (Answer)Mockito.RETURNS_MOCKS), inputEventStream, true);
        invocation.execute(this.outputEventStream);
        InOrder txManagerOrder = Mockito.inOrder((Object[])new Object[]{this.transactionManager});
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).initialize((InitializeContext)Mockito.any(InitializeContext.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).begin((LoginContext)Mockito.any(LoginContext.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyList(), Mockito.eq((boolean)false), ArgumentMatchers.anyMap(), (Duration)ArgumentMatchers.nullable(Duration.class), (String)ArgumentMatchers.nullable(String.class), ArgumentMatchers.anyString());
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).runQuery(TX_ID, "query", MapValue.EMPTY);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).pullData((String)Mockito.any(String.class), ((Integer)Mockito.any(Integer.class)).intValue(), ((Long)Mockito.any(Long.class)).longValue(), (ResultConsumer)Mockito.any(ResultConsumer.class));
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).commit(TX_ID);
        ((TransactionManager)txManagerOrder.verify((Object)this.transactionManager)).cleanUp((CleanUpConnectionContext)Mockito.eq((Object)new CleanUpConnectionContext(TX_ID)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionManager});
        InOrder outputOrder = Mockito.inOrder((Object[])new Object[]{this.outputEventStream});
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementStart(statement, List.of("c1", "c2", "c3"));
        this.verifyDefaultResultRows(outputOrder);
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeStatementEnd((QueryExecutionType)Mockito.any(), (QueryStatistics)Mockito.any(), (ExecutionPlanDescription)Mockito.any(), (Iterable)Mockito.any());
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeTransactionInfo(TransactionNotificationState.COMMITTED, uriScheme.txCommitUri(123L), -1L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.outputEventStream});
    }

    private void verifyDefaultResultRows(InOrder outputOrder) {
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeRecord((List)Mockito.eq(List.of("c1", "c2", "c3")), (Function)ArgumentMatchers.argThat((ArgumentMatcher)new ValuesMatcher(Map.of("c1", "v1", "c2", "v2", "c3", "v3"))));
        ((OutputEventStream)outputOrder.verify((Object)this.outputEventStream)).writeRecord((List)Mockito.eq(List.of("c1", "c2", "c3")), (Function)ArgumentMatchers.argThat((ArgumentMatcher)new ValuesMatcher(Map.of("c1", "v4", "c2", "v5", "c3", "v6"))));
    }

    private TransactionHandle getTransactionHandle(QueryExecutionEngine executionEngine, TransactionRegistry registry) {
        return this.getTransactionHandle(executionEngine, registry, true, true);
    }

    private TransactionHandle getTransactionHandle(QueryExecutionEngine executionEngine, TransactionRegistry registry, boolean implicitTransaction, boolean readOnly) {
        return new TransactionHandle("neo4j", executionEngine, registry, uriScheme, implicitTransaction, LoginContext.AUTH_DISABLED, (ClientConnectionInfo)Mockito.mock(ClientConnectionInfo.class), Mockito.anyLong(), this.transactionManager, this.logProvider, this.boltSPI, this.memoryTracker, this.authManager, Clocks.nanoClock(), readOnly);
    }

    private void setupResultMocks() throws Throwable {
        String[] fieldNames = List.of("c1", "c2", "c3").toArray(new String[0]);
        Mockito.when((Object)this.boltResult.fieldNames()).thenReturn((Object)fieldNames);
        Mockito.when((Object)this.boltResult.handleRecords((BoltResult.RecordConsumer)Mockito.any(BoltResult.RecordConsumer.class), ((Long)Mockito.any(Long.class)).longValue())).thenAnswer(invocation -> {
            BoltResult.RecordConsumer recordConsumer = (BoltResult.RecordConsumer)invocation.getArgument(0, BoltResult.RecordConsumer.class);
            recordConsumer.beginRecord(3);
            recordConsumer.consumeField((AnyValue)Values.stringValue((String)"v1"));
            recordConsumer.consumeField((AnyValue)Values.stringValue((String)"v2"));
            recordConsumer.consumeField((AnyValue)Values.stringValue((String)"v3"));
            recordConsumer.endRecord();
            recordConsumer.beginRecord(3);
            recordConsumer.consumeField((AnyValue)Values.stringValue((String)"v4"));
            recordConsumer.consumeField((AnyValue)Values.stringValue((String)"v5"));
            recordConsumer.consumeField((AnyValue)Values.stringValue((String)"v6"));
            recordConsumer.endRecord();
            recordConsumer.addMetadata("type", (AnyValue)Values.stringValue((String)"w"));
            recordConsumer.addMetadata("db", (AnyValue)Values.stringValue((String)"neo4j"));
            recordConsumer.addMetadata("t_last", (AnyValue)Values.longValue((long)0L));
            return false;
        });
    }

    private static class ValuesMatcher
    implements ArgumentMatcher<Function<String, Object>> {
        private final Map<String, Object> values;

        private ValuesMatcher(Map<String, Object> values) {
            this.values = values;
        }

        public boolean matches(Function<String, Object> valueExtractor) {
            return this.values.entrySet().stream().anyMatch(entry -> entry.getValue().equals(valueExtractor.apply((String)entry.getKey())));
        }
    }
}

