/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.util.Set;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.procedure.builtin.routing.ClientRoutingDomainChecker;
import org.neo4j.server.configuration.ConfigurableServerModules;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.http.cypher.CypherResource;
import org.neo4j.server.rest.discovery.DiscoverableURIs;

public class CommunityDiscoverableURIs {
    public static DiscoverableURIs communityDiscoverableURIs(Config config, ConnectorPortRegister portRegister, ClientRoutingDomainChecker clientRoutingDomainChecker) {
        return CommunityDiscoverableURIs.communityDiscoverableURIsBuilder(config, portRegister, clientRoutingDomainChecker).build();
    }

    public static DiscoverableURIs.Builder communityDiscoverableURIsBuilder(Config config, ConnectorPortRegister portRegister, ClientRoutingDomainChecker clientRoutingDomainChecker) {
        DiscoverableURIs.Builder builder = new DiscoverableURIs.Builder(clientRoutingDomainChecker);
        if (((Set)config.get(ServerSettings.http_enabled_modules)).contains((Object)ConfigurableServerModules.TRANSACTIONAL_ENDPOINTS)) {
            builder = builder.addEndpoint("transaction", CypherResource.absoluteDatabaseTransactionPath(config));
        }
        return builder.addBoltEndpoint(config, portRegister);
    }
}

