/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.util.List;
import org.neo4j.bolt.dbapi.CustomBookmarkFormatParser;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionLifecycleException;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;
import org.neo4j.time.SystemNanoClock;

class TransactionFacade {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransactionFacade.class);
    private final String databaseName;
    private final TransactionRegistry registry;
    private final TransactionManager transactionManager;
    private final InternalLogProvider logProvider;
    private final AuthManager authManager;
    private final boolean readByDefault;
    private CustomBookmarkFormatParser bookmarkFormatParser;

    TransactionFacade(String databaseName, TransactionRegistry registry, TransactionManager transactionManager, InternalLogProvider logProvider, AuthManager authManager, boolean readByDefault, CustomBookmarkFormatParser bookmarkFormatParser) {
        this.databaseName = databaseName;
        this.registry = registry;
        this.transactionManager = transactionManager;
        this.logProvider = logProvider;
        this.authManager = authManager;
        this.readByDefault = readByDefault;
        this.bookmarkFormatParser = bookmarkFormatParser;
    }

    TransactionHandle newTransactionHandle(TransactionUriScheme uriScheme, boolean implicitTransaction, LoginContext loginContext, ClientConnectionInfo clientConnectionInfo, MemoryTracker memoryTracker, long customTransactionTimeout, List<Bookmark> bookmarks) {
        memoryTracker.allocateHeap(TransactionHandle.SHALLOW_SIZE);
        return new TransactionHandle(this.databaseName, this.registry, uriScheme, implicitTransaction, loginContext, clientConnectionInfo, customTransactionTimeout, this.transactionManager, this.logProvider, memoryTracker, this.authManager, this.readByDefault, bookmarks);
    }

    TransactionHandle newTransactionHandle(TransactionUriScheme uriScheme, boolean implicitTransaction, LoginContext loginContext, ClientConnectionInfo clientConnectionInfo, MemoryTracker memoryTracker, long customTransactionTimeout, SystemNanoClock clock, boolean isReadOnlyTransaction, List<Bookmark> bookmarks) {
        memoryTracker.allocateHeap(TransactionHandle.SHALLOW_SIZE);
        return new TransactionHandle(this.databaseName, this.registry, uriScheme, implicitTransaction, loginContext, clientConnectionInfo, customTransactionTimeout, this.transactionManager, this.logProvider, memoryTracker, this.authManager, isReadOnlyTransaction, bookmarks);
    }

    TransactionHandle findTransactionHandle(long txId, LoginContext requestingUser) throws TransactionLifecycleException {
        return this.registry.acquire(txId, requestingUser);
    }

    TransactionHandle terminate(long txId, LoginContext loginContext) throws TransactionLifecycleException {
        return this.registry.terminate(txId, loginContext);
    }

    CustomBookmarkFormatParser bookmarkParser() {
        return this.bookmarkFormatParser;
    }
}

