/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.connector.tx.TransactionOwner;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.request.connection.RoutingContext;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.server.http.cypher.TransactionTerminationHandle;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;

public class TransactionHandle
implements TransactionTerminationHandle,
TransactionOwner {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransactionHandle.class);
    private final String databaseName;
    private final TransactionRegistry registry;
    private final TransactionUriScheme uriScheme;
    private final TransactionManager transactionManager;
    private final KernelTransaction.Type type;
    private final Duration customTransactionTimeout;
    private final long id;
    private long expirationTimestamp = -1L;
    private final InternalLogProvider userLogProvider;
    private final ClientConnectionInfo clientConnectionInfo;
    private final boolean readByDefault;
    private Transaction transaction;
    private LoginContext loginContext;
    MemoryTracker memoryTracker;
    AuthManager authManager;
    private final List<Bookmark> inputBookmarks;
    private String encodedBookmark;

    TransactionHandle(String databaseName, TransactionRegistry registry, TransactionUriScheme uriScheme, boolean implicitTransaction, LoginContext loginContext, ClientConnectionInfo clientConnectionInfo, long customTransactionTimeoutMillis, TransactionManager transactionManager, InternalLogProvider logProvider, MemoryTracker memoryTracker, AuthManager authManager, boolean readByDefault, List<Bookmark> bookmarks) {
        this.databaseName = databaseName;
        this.registry = registry;
        this.uriScheme = uriScheme;
        this.type = implicitTransaction ? KernelTransaction.Type.IMPLICIT : KernelTransaction.Type.EXPLICIT;
        this.customTransactionTimeout = customTransactionTimeoutMillis != 0L ? Duration.ofMillis(customTransactionTimeoutMillis) : null;
        this.id = registry.begin(this);
        this.transactionManager = transactionManager;
        this.userLogProvider = logProvider;
        this.loginContext = loginContext;
        this.clientConnectionInfo = clientConnectionInfo;
        this.memoryTracker = memoryTracker;
        this.authManager = authManager;
        this.readByDefault = readByDefault;
        this.inputBookmarks = bookmarks;
    }

    URI uri() {
        return this.uriScheme.txUri(this.id);
    }

    boolean isImplicit() {
        return this.type == KernelTransaction.Type.IMPLICIT;
    }

    long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    long getId() {
        return this.id;
    }

    @Override
    public boolean terminate() {
        this.transaction.interrupt();
        return true;
    }

    void ensureActiveTransaction() throws TransactionException {
        if (this.transaction == null) {
            this.beginTransaction();
        }
    }

    org.neo4j.bolt.tx.statement.Statement executeStatement(Statement statement) throws TransactionException {
        return this.transaction.run(statement.getStatement(), ValueUtils.asParameterMapValue(statement.getParameters()));
    }

    void forceRollback() throws TransactionException {
        this.transaction.rollback();
        this.transaction.close();
    }

    void suspendTransaction() {
        this.expirationTimestamp = this.registry.release(this.id, this);
    }

    void commit() throws TransactionException {
        try {
            this.encodedBookmark = this.transaction.commit().serialize();
        }
        finally {
            this.registry.forget(this.id);
            this.transaction.close();
        }
    }

    void rollback() throws TransactionException {
        try {
            this.transaction.rollback();
        }
        finally {
            this.registry.forget(this.id);
            this.transaction.close();
        }
    }

    public LoginContext loginContext() {
        return this.loginContext;
    }

    boolean hasTransactionContext() {
        return this.transaction != null;
    }

    public MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }

    public ClientConnectionInfo info() {
        return this.clientConnectionInfo;
    }

    public String selectedDefaultDatabase() {
        return this.databaseName;
    }

    public void beginTransaction() throws TransactionException {
        this.transaction = this.transactionManager.create(this.isImplicit() ? TransactionType.IMPLICIT : TransactionType.EXPLICIT, (TransactionOwner)this, this.databaseName, this.readByDefault ? AccessMode.READ : AccessMode.WRITE, this.inputBookmarks, this.customTransactionTimeout, Collections.emptyMap(), null);
    }

    public TransactionManager transactionManager() {
        return this.transactionManager;
    }

    public RoutingContext routingContext() {
        return new RoutingContext(true, Map.of());
    }

    public String getOutputBookmark() {
        return this.encodedBookmark;
    }

    public void setOutputBookmark(String encodedBookmark) {
        this.encodedBookmark = encodedBookmark;
    }
}

