/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.server.configuration.ConfigurableServerModules;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class ServerSettingsMigratorTest {
    @Inject
    private TestDirectory testDirectory;

    ServerSettingsMigratorTest() {
    }

    @Test
    void testWhitelistSettingsRename() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.security.http_auth_whitelist=a,b"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessageWithArguments("Use of deprecated setting '%s'. It is replaced by '%s'.", new Object[]{"dbms.security.http_auth_whitelist", ServerSettings.http_auth_allowlist.name()});
        Assertions.assertEquals(List.of("a", "b"), (Object)config.get(ServerSettings.http_auth_allowlist));
    }

    @Test
    void migrateThirdPartyPackagesSetting() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of(" dbms.unmanaged_extension_classes=org.neo4j.test.server.unmanaged=/examples/test"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        config.setLogger(logProvider.getLog(Config.class));
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Config.class).forLevel(AssertableLogProvider.Level.WARN).containsMessageWithArguments("Use of deprecated setting '%s'. It is replaced by '%s'.", new Object[]{"dbms.unmanaged_extension_classes", ServerSettings.third_party_packages.name()});
        ((ListAssert)LogAssertions.assertThat((List)((List)config.get(ServerSettings.third_party_packages))).hasSize(1)).contains((Object[])new ThirdPartyJaxRsPackage[]{new ThirdPartyJaxRsPackage("org.neo4j.test.server.unmanaged", "/examples/test")});
    }

    @Test
    void migrateMaxThreads() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.threads.worker_count=9874"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertEquals((int)9874, (Integer)((Integer)config.get(ServerSettings.webserver_max_threads)));
    }

    @Test
    void migrateEnabledModulesSettings() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("dbms.http_enabled_modules=TRANSACTIONAL_ENDPOINTS"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertEquals(Set.of(ConfigurableServerModules.TRANSACTIONAL_ENDPOINTS), (Object)config.get(ServerSettings.http_enabled_modules));
    }

    @Test
    void migrateClientsTelemetrySetting() throws IOException {
        Path confFile = this.testDirectory.createFile("test.conf");
        Files.write(confFile, List.of("client.allow_telemetry=false"), new OpenOption[0]);
        Config config = Config.newBuilder().fromFile(confFile).build();
        Assertions.assertFalse((boolean)((Boolean)config.get(ServerSettings.allow_telemetry)));
    }
}

