/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.server.http.cypher.format.jolt.v1.JoltV1Codec;
import org.neo4j.server.http.cypher.format.jolt.v2.JoltV2Codec;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public class JoltBasicTypesSerializerTest {
    private static final ObjectMapper om = new ObjectMapper();

    public static Stream<? extends ObjectMapper> sparseMappers() {
        return Stream.of(new JoltV1Codec(false), new JoltV2Codec(false));
    }

    public static Stream<? extends ObjectMapper> strictMappers() {
        return Stream.of(new JoltV1Codec(true), new JoltV2Codec(true));
    }

    @ParameterizedTest
    @MethodSource(value={"sparseMappers"})
    void shouldUseSparseJSONString(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString((Object)"Hello, World");
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("\"Hello, World\"");
    }

    @ParameterizedTest
    @MethodSource(value={"sparseMappers"})
    void shouldUseSparseJSONBoolean(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString((Object)true);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("true");
    }

    @ParameterizedTest
    @MethodSource(value={"sparseMappers"})
    void shouldUseSparseJSONList(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString(List.of(Integer.valueOf(1), Integer.valueOf(2), "3"));
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("[1,2,\"3\"]");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeNull(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString(null);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("null");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeInteger(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString((Object)123);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"Z\":\"123\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeBoolean(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString((Object)true);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"?\":\"true\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeLongInsideInt32Range(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString((Object)123L);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"Z\":\"123\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeLongAboveInt32Range(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString((Object)0x80000000L);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"R\":\"2147483648\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeLongBelowInt32Range(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString((Object)-2147483649L);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"R\":\"-2147483649\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeDouble(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString((Object)42.23);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"R\":\"42.23\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeString(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString((Object)"Hello, World");
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"U\":\"Hello, World\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializePoint(ObjectMapper mapper) throws JsonProcessingException {
        PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{12.994823, 55.612191});
        String result = mapper.writeValueAsString((Object)point);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"@\":\"SRID=4326;POINT(12.994823 55.612191)\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeDuration(ObjectMapper mapper) throws JsonProcessingException {
        DurationValue duration = DurationValue.duration((Duration)Duration.ofDays(20L));
        String result = mapper.writeValueAsString((Object)duration);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"T\":\"PT480H\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeLargeDuration(ObjectMapper mapper) throws JsonProcessingException {
        String durationString = "P3Y6M4DT12H30M5S";
        DurationValue durationValue = DurationValue.parse((CharSequence)durationString);
        String result = mapper.writeValueAsString((Object)durationValue);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"T\":\"" + durationString + "\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeDate(ObjectMapper mapper) throws JsonProcessingException {
        String dateString = "2020-08-25";
        LocalDate date = LocalDate.parse(dateString);
        String result = mapper.writeValueAsString((Object)date);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"T\":\"" + dateString + "\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeTime(ObjectMapper mapper) throws JsonProcessingException {
        String timeString = "12:52:58.513775";
        LocalTime time = LocalTime.parse(timeString);
        String result = mapper.writeValueAsString((Object)time);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"T\":\"" + timeString + "\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeOffsetTime(ObjectMapper mapper) throws JsonProcessingException {
        String offsetTimeString = "12:55:10.775607+01:00";
        OffsetTime time = OffsetTime.parse(offsetTimeString);
        String result = mapper.writeValueAsString((Object)time);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"T\":\"" + offsetTimeString + "\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeLocalDateTime(ObjectMapper mapper) throws JsonProcessingException {
        String localDateTimeString = "2020-08-25T12:57:36.069665";
        LocalDateTime dateTime = LocalDateTime.parse(localDateTimeString);
        String result = mapper.writeValueAsString((Object)dateTime);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"T\":\"" + localDateTimeString + "\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeZonedDateTime(ObjectMapper mapper) throws JsonProcessingException {
        String zonedDateTimeString = "2020-08-25T13:03:39.11733+01:00[Europe/London]";
        ZonedDateTime dateTime = ZonedDateTime.parse(zonedDateTimeString);
        String result = mapper.writeValueAsString((Object)dateTime);
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"T\":\"" + zonedDateTimeString + "\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeLongArray(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString((Object)new Long[]{0L, 1L, 2L});
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("[{\"Z\":\"0\"},{\"Z\":\"1\"},{\"Z\":\"2\"}]");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeByteArray(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString((Object)new byte[]{0, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"#\":\"0001020304050608090A0B0C0D0E0F10\"}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeArrays(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString((Object)new String[]{"A", "B"});
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("[{\"U\":\"A\"},{\"U\":\"B\"}]");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeHomogenousList(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"[]\":[{\"Z\":\"1\"},{\"Z\":\"2\"},{\"Z\":\"3\"}]}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeHeterogeneousList(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString(List.of("A", Integer.valueOf(21), Double.valueOf(42.3)));
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"[]\":[{\"U\":\"A\"},{\"Z\":\"21\"},{\"R\":\"42.3\"}]}");
    }

    @ParameterizedTest
    @MethodSource(value={"strictMappers"})
    void shouldSerializeMap(ObjectMapper mapper) throws JsonProcessingException {
        String result = mapper.writeValueAsString(new TreeMap<String, Integer>(Map.of("name", "Alice", "age", 33)));
        JoltBasicTypesSerializerTest.assertValidJSON(result);
        Assertions.assertThat((String)result).isEqualTo("{\"{}\":{\"age\":{\"Z\":\"33\"},\"name\":{\"U\":\"Alice\"}}}");
    }

    public static void assertValidJSON(String json) {
        try {
            om.readTree(json);
        }
        catch (JsonProcessingException e) {
            Assertions.fail((String)"Invalid JSON: ", (Object[])new Object[]{json});
        }
    }
}

