/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoWebServer;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.DBMSModule;
import org.neo4j.server.rest.discovery.DiscoverableURIs;
import org.neo4j.server.rest.repr.CommunityAuthConfigProvider;
import org.neo4j.server.web.WebServer;

public class DBMSModuleTest {
    @Test
    public void shouldRegisterAtRootByDefault() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        Config config = (Config)Mockito.mock(Config.class);
        CommunityNeoWebServer neoServer = (CommunityNeoWebServer)Mockito.mock(CommunityNeoWebServer.class);
        Mockito.when((Object)neoServer.getBaseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        Mockito.when((Object)((Boolean)config.get(GraphDatabaseSettings.auth_enabled))).thenReturn((Object)true);
        Mockito.when((Object)((List)config.get(ServerSettings.http_paths_blacklist))).thenReturn(Collections.emptyList());
        DBMSModule module = new DBMSModule(webServer, config, () -> new DiscoverableURIs.Builder(null).build(), (InternalLogProvider)NullLogProvider.getInstance(), (AuthConfigProvider)new CommunityAuthConfigProvider());
        module.start();
        ((WebServer)Mockito.verify((Object)webServer)).addJAXRSClasses(ArgumentMatchers.anyList(), ArgumentMatchers.anyString(), (Collection)ArgumentMatchers.isNull());
    }
}

