/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.security.AuthProviderFailedException;
import org.neo4j.graphdb.security.AuthProviderTimeoutException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.server.rest.dbms.AuthorizationFilter;
import org.neo4j.server.rest.dbms.AuthorizationHeaders;
import org.neo4j.server.rest.dbms.AuthorizedRequestWrapper;
import org.neo4j.server.rest.web.HttpConnectionInfoFactory;
import org.neo4j.server.web.JettyHttpConnection;
import org.neo4j.string.UTF8;

public class AuthorizationEnabledFilter
extends AuthorizationFilter {
    private final Supplier<AuthManager> authManagerSupplier;
    private final InternalLog log;
    private final List<Pattern> uriWhitelist;
    private static final ThrowingConsumer<HttpServletResponse, IOException> noHeader = AuthorizationEnabledFilter.error(401, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Security.Unauthorized.code().serialize(), "message", "No authentication header supplied."}))}));
    private static final ThrowingConsumer<HttpServletResponse, IOException> badHeader = AuthorizationEnabledFilter.error(400, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Request.InvalidFormat.code().serialize(), "message", "Invalid authentication header."}))}));
    private static final ThrowingConsumer<HttpServletResponse, IOException> invalidCredential = AuthorizationEnabledFilter.error(401, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Security.Unauthorized.code().serialize(), "message", "Invalid username or password."}))}));
    private static final ThrowingConsumer<HttpServletResponse, IOException> tooManyAttempts = AuthorizationEnabledFilter.error(429, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Security.AuthenticationRateLimit.code().serialize(), "message", "Too many failed authentication requests. Please wait 5 seconds and try again."}))}));
    private static final ThrowingConsumer<HttpServletResponse, IOException> authProviderFailed = AuthorizationEnabledFilter.error(502, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Security.AuthProviderFailed.code().serialize(), "message", "An auth provider request failed."}))}));
    private static final ThrowingConsumer<HttpServletResponse, IOException> authProviderTimeout = AuthorizationEnabledFilter.error(504, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Security.AuthProviderTimeout.code().serialize(), "message", "An auth provider request timed out."}))}));

    public AuthorizationEnabledFilter(Supplier<AuthManager> authManager, InternalLogProvider logProvider, List<Pattern> uriWhitelist) {
        this.authManagerSupplier = authManager;
        this.log = logProvider.getLog(this.getClass());
        this.uriWhitelist = uriWhitelist;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        AuthorizationEnabledFilter.validateRequestType(servletRequest);
        AuthorizationEnabledFilter.validateResponseType(servletResponse);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String userAgent = request.getHeader("User-Agent");
        JettyHttpConnection.updateUserForCurrentConnection(null, userAgent);
        String path = request.getContextPath() + (request.getPathInfo() == null ? "" : request.getPathInfo());
        if (request.getMethod().equals("OPTIONS") || this.whitelisted(path)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String header = request.getHeader("Authorization");
        if (header == null) {
            AuthorizationEnabledFilter.requestAuthentication(request, noHeader).accept((Object)response);
            return;
        }
        String[] usernameAndPassword = AuthorizationEnabledFilter.extractCredential(header);
        if (usernameAndPassword == null) {
            badHeader.accept((Object)response);
            return;
        }
        String username = usernameAndPassword[0];
        String password = usernameAndPassword[1];
        try {
            ClientConnectionInfo connectionInfo = HttpConnectionInfoFactory.create(request);
            LoginContext securityContext = this.authenticate(username, password, connectionInfo);
            JettyHttpConnection.updateUserForCurrentConnection(username, userAgent);
            switch (securityContext.subject().getAuthenticationResult()) {
                case PASSWORD_CHANGE_REQUIRED: 
                case SUCCESS: {
                    try {
                        filterChain.doFilter((ServletRequest)new AuthorizedRequestWrapper("BASIC", username, request, securityContext), servletResponse);
                    }
                    catch (AuthorizationViolationException e) {
                        AuthorizationEnabledFilter.unauthorizedAccess(e.getMessage()).accept((Object)response);
                    }
                    return;
                }
                case TOO_MANY_ATTEMPTS: {
                    tooManyAttempts.accept((Object)response);
                    return;
                }
            }
            this.log.warn("Failed authentication attempt for '%s' from %s", new Object[]{username, request.getRemoteAddr()});
            AuthorizationEnabledFilter.requestAuthentication(request, invalidCredential).accept((Object)response);
        }
        catch (InvalidAuthTokenException e) {
            AuthorizationEnabledFilter.requestAuthentication(request, AuthorizationEnabledFilter.invalidAuthToken(e.getMessage())).accept((Object)response);
        }
        catch (AuthProviderTimeoutException e) {
            authProviderTimeout.accept((Object)response);
        }
        catch (AuthProviderFailedException e) {
            authProviderFailed.accept((Object)response);
        }
    }

    private LoginContext authenticate(String username, String password, ClientConnectionInfo connectionInfo) throws InvalidAuthTokenException {
        AuthManager authManager = this.authManagerSupplier.get();
        Map authToken = AuthToken.newBasicAuthToken((String)username, (byte[])(password != null ? UTF8.encode((String)password) : null));
        return authManager.login(authToken, connectionInfo);
    }

    private static ThrowingConsumer<HttpServletResponse, IOException> invalidAuthToken(String message) {
        return AuthorizationEnabledFilter.error(401, MapUtil.map((Object[])new Object[]{"errors", Collections.singletonList(MapUtil.map((Object[])new Object[]{"code", Status.Security.Unauthorized.code().serialize(), "message", message}))}));
    }

    private static ThrowingConsumer<HttpServletResponse, IOException> requestAuthentication(HttpServletRequest req, ThrowingConsumer<HttpServletResponse, IOException> responseGen) {
        if ("true".equals(req.getHeader("X-Ajax-Browser-Auth"))) {
            return res -> {
                responseGen.accept(res);
                res.addHeader("WWW-Authenticate", "None");
            };
        }
        return res -> {
            responseGen.accept(res);
            res.addHeader("WWW-Authenticate", "Basic realm=\"Neo4j\"");
        };
    }

    private boolean whitelisted(String path) {
        for (Pattern pattern : this.uriWhitelist) {
            if (!pattern.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    private static String[] extractCredential(String header) {
        if (header == null) {
            return null;
        }
        return AuthorizationHeaders.decode(header);
    }
}

