/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.messaging.request;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.bolt.connection.NotificationClassification;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.NotificationSeverity;
import org.neo4j.bolt.connection.netty.impl.messaging.Message;
import org.neo4j.bolt.connection.values.Value;
import org.neo4j.bolt.connection.values.ValueFactory;

abstract class MessageWithMetadata
implements Message {
    static final String NOTIFICATIONS_MINIMUM_SEVERITY = "notifications_minimum_severity";
    static final String NOTIFICATIONS_DISABLED_CATEGORIES = "notifications_disabled_categories";
    static final String NOTIFICATIONS_DISABLED_CLASSIFICATIONS = "notifications_disabled_classifications";
    private final Map<String, Value> metadata;

    public MessageWithMetadata(Map<String, Value> metadata) {
        this.metadata = metadata;
    }

    public Map<String, Value> metadata() {
        return this.metadata;
    }

    static void appendNotificationConfig(Map<String, Value> result, NotificationConfig config, boolean legacyNotifications, ValueFactory valueFactory) {
        if (config != null) {
            Set disabledClassifications;
            NotificationSeverity severity = config.minimumSeverity();
            if (severity != null) {
                result.put(NOTIFICATIONS_MINIMUM_SEVERITY, valueFactory.value((Object)severity.type().toString()));
            }
            if ((disabledClassifications = config.disabledClassifications()) != null) {
                List<String> list = disabledClassifications.stream().map(NotificationClassification::type).map(Enum::toString).toList();
                result.put(legacyNotifications ? NOTIFICATIONS_DISABLED_CATEGORIES : NOTIFICATIONS_DISABLED_CLASSIFICATIONS, valueFactory.value(list));
            }
        }
    }
}

