/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.messaging.v4;

import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.ClusterComposition;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.DatabaseNameUtil;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.netty.impl.handlers.PullResponseHandlerImpl;
import org.neo4j.bolt.connection.netty.impl.handlers.RunResponseHandler;
import org.neo4j.bolt.connection.netty.impl.messaging.BoltProtocol;
import org.neo4j.bolt.connection.netty.impl.messaging.MessageFormat;
import org.neo4j.bolt.connection.netty.impl.messaging.MessageHandler;
import org.neo4j.bolt.connection.netty.impl.messaging.PullMessageHandler;
import org.neo4j.bolt.connection.netty.impl.messaging.request.PullMessage;
import org.neo4j.bolt.connection.netty.impl.messaging.request.RunWithMetadataMessage;
import org.neo4j.bolt.connection.netty.impl.messaging.v3.BoltProtocolV3;
import org.neo4j.bolt.connection.netty.impl.messaging.v4.MessageFormatV4;
import org.neo4j.bolt.connection.netty.impl.spi.Connection;
import org.neo4j.bolt.connection.summary.PullSummary;
import org.neo4j.bolt.connection.summary.RouteSummary;
import org.neo4j.bolt.connection.summary.RunSummary;
import org.neo4j.bolt.connection.values.Value;
import org.neo4j.bolt.connection.values.ValueFactory;

public class BoltProtocolV4
extends BoltProtocolV3 {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(4, 0);
    public static final BoltProtocol INSTANCE = new BoltProtocolV4();
    private static final String ROUTING_CONTEXT = "context";
    private static final String DATABASE_NAME = "database";
    private static final String MULTI_DB_GET_ROUTING_TABLE = String.format("CALL dbms.routing.getRoutingTable($%s, $%s)", "context", "database");

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV4();
    }

    @Override
    public CompletionStage<Void> route(Connection connection, Map<String, Value> routingContext, Set<String> bookmarks, String databaseName, String impersonatedUser, MessageHandler<RouteSummary> handler, Clock clock, LoggingProvider logging, ValueFactory valueFactory) {
        BoltProtocolV3.Query query = new BoltProtocolV3.Query(MULTI_DB_GET_ROUTING_TABLE, Map.of(ROUTING_CONTEXT, valueFactory.value(routingContext), DATABASE_NAME, valueFactory.value((Object)databaseName)));
        RunWithMetadataMessage runMessage = RunWithMetadataMessage.autoCommitTxRunMessage(query.query(), query.parameters(), null, Collections.emptyMap(), DatabaseNameUtil.database((String)"system"), AccessMode.READ, bookmarks, null, NotificationConfig.defaultConfig(), this.useLegacyNotifications(), logging, valueFactory);
        final CompletableFuture<RunSummary> runFuture = new CompletableFuture<RunSummary>();
        RunResponseHandler runHandler = new RunResponseHandler(runFuture, METADATA_EXTRACTOR);
        final CompletableFuture pullFuture = new CompletableFuture();
        ((CompletableFuture)((CompletableFuture)runFuture.thenCompose(ignored -> pullFuture)).thenApply(map -> {
            long ttl = ((Value)map.get("ttl")).asLong();
            long expirationTimestamp = clock.millis() + ttl * 1000L;
            if (ttl < 0L || ttl >= 9223372036854775L || expirationTimestamp < 0L) {
                expirationTimestamp = Long.MAX_VALUE;
            }
            LinkedHashSet<BoltServerAddress> readers = new LinkedHashSet<BoltServerAddress>();
            LinkedHashSet<BoltServerAddress> writers = new LinkedHashSet<BoltServerAddress>();
            LinkedHashSet<BoltServerAddress> routers = new LinkedHashSet<BoltServerAddress>();
            for (Value serversMap : ((Value)map.get("servers")).values()) {
                String role = serversMap.get("role").asString();
                for (Value server : serversMap.get("addresses").values()) {
                    BoltServerAddress address = new BoltServerAddress(server.asString());
                    switch (role) {
                        case "WRITE": {
                            writers.add(address);
                            break;
                        }
                        case "READ": {
                            readers.add(address);
                            break;
                        }
                        case "ROUTE": {
                            routers.add(address);
                        }
                    }
                }
            }
            Value db = (Value)map.get("db");
            String name = null;
            if (db != null && !db.isNull()) {
                name = db.asString();
            }
            ClusterComposition clusterComposition = new ClusterComposition(expirationTimestamp, readers, writers, routers, name);
            return new RouteSummaryImpl(clusterComposition);
        })).whenComplete((summary, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                handler.onSummary((RouteSummary)summary);
            }
        });
        return connection.write(runMessage, runHandler).thenCompose(ignored -> {
            PullMessage pullMessage = new PullMessage(-1L, -1L, valueFactory);
            PullResponseHandlerImpl pullHandler = new PullResponseHandlerImpl(new PullMessageHandler(){
                private Map<String, Value> routingTable;

                @Override
                public void onRecord(Value[] fields) {
                    if (this.routingTable == null) {
                        List keys = ((RunSummary)runFuture.join()).keys();
                        this.routingTable = new HashMap<String, Value>(keys.size());
                        for (int i = 0; i < keys.size(); ++i) {
                            this.routingTable.put((String)keys.get(i), fields[i]);
                        }
                        this.routingTable = Collections.unmodifiableMap(this.routingTable);
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    pullFuture.completeExceptionally(throwable);
                }

                @Override
                public void onSummary(PullSummary success) {
                    pullFuture.complete(this.routingTable);
                }
            }, valueFactory);
            return connection.write(pullMessage, pullHandler);
        });
    }

    @Override
    public CompletionStage<Void> pull(Connection connection, long qid, long request, PullMessageHandler handler, ValueFactory valueFactory) {
        PullMessage pullMessage = new PullMessage(request, qid, valueFactory);
        PullResponseHandlerImpl pullHandler = new PullResponseHandlerImpl(handler, valueFactory);
        return connection.write(pullMessage, pullHandler);
    }

    @Override
    protected void verifyDatabaseNameBeforeTransaction(DatabaseName databaseName) {
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }

    private record RouteSummaryImpl(ClusterComposition clusterComposition) implements RouteSummary
    {
    }
}

